@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property affinity The affinity setting for an instance on a Dedicated Host.
 * @property availabilityZone The Availability Zone for the instance.
 * @property groupName The name of the placement group for the instance.
 * @property hostId The ID of the Dedicated Host for the instance.
 * @property hostResourceGroupArn The ARN of the Host Resource Group in which to launch instances.
 * @property partitionNumber The number of the partition the instance should launch in. Valid only if the placement group strategy is set to partition.
 * @property spreadDomain Reserved for future use.
 * @property tenancy The tenancy of the instance (if the instance is running in a VPC). Can be `default`, `dedicated`, or `host`.
 */
public data class LaunchTemplatePlacement(
    public val affinity: String? = null,
    public val availabilityZone: String? = null,
    public val groupName: String? = null,
    public val hostId: String? = null,
    public val hostResourceGroupArn: String? = null,
    public val partitionNumber: Int? = null,
    public val spreadDomain: String? = null,
    public val tenancy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplatePlacement): LaunchTemplatePlacement = LaunchTemplatePlacement(
            affinity = javaType.affinity().map({ args0 -> args0 }).orElse(null),
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            groupName = javaType.groupName().map({ args0 -> args0 }).orElse(null),
            hostId = javaType.hostId().map({ args0 -> args0 }).orElse(null),
            hostResourceGroupArn = javaType.hostResourceGroupArn().map({ args0 -> args0 }).orElse(null),
            partitionNumber = javaType.partitionNumber().map({ args0 -> args0 }).orElse(null),
            spreadDomain = javaType.spreadDomain().map({ args0 -> args0 }).orElse(null),
            tenancy = javaType.tenancy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
