@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property resourceType The type of resource to tag.
 * @property tags A map of tags to assign to the resource.
 */
public data class LaunchTemplateTagSpecification(
    public val resourceType: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplateTagSpecification): LaunchTemplateTagSpecification = LaunchTemplateTagSpecification(
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
