@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidr CIDR block of this entry.
 * @property description Description of this entry. Due to API limitations, updating only the description of an existing entry requires temporarily removing and re-adding the entry.
 */
public data class ManagedPrefixListEntry(
    public val cidr: String,
    public val description: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.ManagedPrefixListEntry): ManagedPrefixListEntry = ManagedPrefixListEntry(
            cidr = javaType.cidr(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
        )
    }
}
