@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cidr
 * @property direction
 * @property portRanges
 * @property prefixListId
 * @property protocol
 * @property securityGroupId
 */
public data class NetworkInsightsAnalysisExplanationSecurityGroupRule(
    public val cidr: String? = null,
    public val direction: String? = null,
    public val portRanges: List<NetworkInsightsAnalysisExplanationSecurityGroupRulePortRange>? = null,
    public val prefixListId: String? = null,
    public val protocol: String? = null,
    public val securityGroupId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.NetworkInsightsAnalysisExplanationSecurityGroupRule): NetworkInsightsAnalysisExplanationSecurityGroupRule =
            NetworkInsightsAnalysisExplanationSecurityGroupRule(
                cidr = javaType.cidr().map({ args0 -> args0 }).orElse(null),
                direction = javaType.direction().map({ args0 -> args0 }).orElse(null),
                portRanges = javaType.portRanges().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationSecurityGroupRulePortRange.Companion.toKotlin(args0)
                    })
                }),
                prefixListId = javaType.prefixListId().map({ args0 -> args0 }).orElse(null),
                protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
                securityGroupId = javaType.securityGroupId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
