@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aclRules
 * @property additionalDetails
 * @property attachedTos
 * @property components
 * @property destinationVpcs
 * @property inboundHeaders
 * @property outboundHeaders
 * @property routeTableRoutes
 * @property securityGroupRules
 * @property sequenceNumber
 * @property sourceVpcs
 * @property subnets
 * @property transitGatewayRouteTableRoutes
 * @property transitGateways
 * @property vpcs
 */
public data class NetworkInsightsAnalysisReturnPathComponent(
    public val aclRules: List<NetworkInsightsAnalysisReturnPathComponentAclRule>? = null,
    public val additionalDetails: List<NetworkInsightsAnalysisReturnPathComponentAdditionalDetail>? =
        null,
    public val attachedTos: List<NetworkInsightsAnalysisReturnPathComponentAttachedTo>? = null,
    public val components: List<NetworkInsightsAnalysisReturnPathComponentComponent>? = null,
    public val destinationVpcs: List<NetworkInsightsAnalysisReturnPathComponentDestinationVpc>? =
        null,
    public val inboundHeaders: List<NetworkInsightsAnalysisReturnPathComponentInboundHeader>? = null,
    public val outboundHeaders: List<NetworkInsightsAnalysisReturnPathComponentOutboundHeader>? =
        null,
    public val routeTableRoutes: List<NetworkInsightsAnalysisReturnPathComponentRouteTableRoute>? =
        null,
    public val securityGroupRules: List<NetworkInsightsAnalysisReturnPathComponentSecurityGroupRule>? =
        null,
    public val sequenceNumber: Int? = null,
    public val sourceVpcs: List<NetworkInsightsAnalysisReturnPathComponentSourceVpc>? = null,
    public val subnets: List<NetworkInsightsAnalysisReturnPathComponentSubnet>? = null,
    public val transitGatewayRouteTableRoutes: List<NetworkInsightsAnalysisReturnPathComponentTransitGatewayRouteTableRoute>? = null,
    public val transitGateways: List<NetworkInsightsAnalysisReturnPathComponentTransitGateway>? =
        null,
    public val vpcs: List<NetworkInsightsAnalysisReturnPathComponentVpc>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.NetworkInsightsAnalysisReturnPathComponent): NetworkInsightsAnalysisReturnPathComponent = NetworkInsightsAnalysisReturnPathComponent(
            aclRules = javaType.aclRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentAclRule.Companion.toKotlin(args0)
                })
            }),
            additionalDetails = javaType.additionalDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentAdditionalDetail.Companion.toKotlin(args0)
                })
            }),
            attachedTos = javaType.attachedTos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentAttachedTo.Companion.toKotlin(args0)
                })
            }),
            components = javaType.components().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentComponent.Companion.toKotlin(args0)
                })
            }),
            destinationVpcs = javaType.destinationVpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentDestinationVpc.Companion.toKotlin(args0)
                })
            }),
            inboundHeaders = javaType.inboundHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentInboundHeader.Companion.toKotlin(args0)
                })
            }),
            outboundHeaders = javaType.outboundHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentOutboundHeader.Companion.toKotlin(args0)
                })
            }),
            routeTableRoutes = javaType.routeTableRoutes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentRouteTableRoute.Companion.toKotlin(args0)
                })
            }),
            securityGroupRules = javaType.securityGroupRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentSecurityGroupRule.Companion.toKotlin(args0)
                })
            }),
            sequenceNumber = javaType.sequenceNumber().map({ args0 -> args0 }).orElse(null),
            sourceVpcs = javaType.sourceVpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentSourceVpc.Companion.toKotlin(args0)
                })
            }),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentSubnet.Companion.toKotlin(args0)
                })
            }),
            transitGatewayRouteTableRoutes = javaType.transitGatewayRouteTableRoutes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentTransitGatewayRouteTableRoute.Companion.toKotlin(args0)
                })
            }),
            transitGateways = javaType.transitGateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentTransitGateway.Companion.toKotlin(args0)
                })
            }),
            vpcs = javaType.vpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentVpc.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
