@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property destinationAddresses
 * @property destinationPortRanges
 * @property protocol
 * @property sourceAddresses
 * @property sourcePortRanges
 */
public data class NetworkInsightsAnalysisReturnPathComponentOutboundHeader(
    public val destinationAddresses: List<String>? = null,
    public val destinationPortRanges: List<NetworkInsightsAnalysisReturnPathComponentOutboundHeaderDestinationPortRange>? = null,
    public val protocol: String? = null,
    public val sourceAddresses: List<String>? = null,
    public val sourcePortRanges: List<NetworkInsightsAnalysisReturnPathComponentOutboundHeaderSourcePortRange>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.NetworkInsightsAnalysisReturnPathComponentOutboundHeader): NetworkInsightsAnalysisReturnPathComponentOutboundHeader =
            NetworkInsightsAnalysisReturnPathComponentOutboundHeader(
                destinationAddresses = javaType.destinationAddresses().map({ args0 -> args0 }),
                destinationPortRanges = javaType.destinationPortRanges().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentOutboundHeaderDestinationPortRange.Companion.toKotlin(args0)
                    })
                }),
                protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
                sourceAddresses = javaType.sourceAddresses().map({ args0 -> args0 }),
                sourcePortRanges = javaType.sourcePortRanges().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisReturnPathComponentOutboundHeaderSourcePortRange.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
