@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property launchTemplateSpecification Launch template specification. See Launch Template Specification below for more details.
 * @property overrides One or more override configurations. See Overrides below for more details.
 */
public data class SpotFleetRequestLaunchTemplateConfig(
    public val launchTemplateSpecification: SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecification,
    public val overrides: List<SpotFleetRequestLaunchTemplateConfigOverride>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.SpotFleetRequestLaunchTemplateConfig): SpotFleetRequestLaunchTemplateConfig = SpotFleetRequestLaunchTemplateConfig(
            launchTemplateSpecification = javaType.launchTemplateSpecification().let({ args0 ->
                com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecification.Companion.toKotlin(args0)
            }),
            overrides = javaType.overrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchTemplateConfigOverride.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
