@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property acceleratorCount Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum.
 * @property acceleratorManufacturers List of accelerator manufacturer names. Default is any manufacturer.
 * ```
 * Valid names:
 * * amazon-web-services
 * * amd
 * * nvidia
 * * xilinx
 * ```
 * @property acceleratorNames List of accelerator names. Default is any acclerator.
 * ```
 * Valid names:
 * * a100            - NVIDIA A100 GPUs
 * * v100            - NVIDIA V100 GPUs
 * * k80             - NVIDIA K80 GPUs
 * * t4              - NVIDIA T4 GPUs
 * * m60             - NVIDIA M60 GPUs
 * * radeon-pro-v520 - AMD Radeon Pro V520 GPUs
 * * vu9p            - Xilinx VU9P FPGAs
 * ```
 * @property acceleratorTotalMemoryMib Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
 * @property acceleratorTypes List of accelerator types. Default is any accelerator type.
 * ```
 * Valid types:
 * * fpga
 * * gpu
 * * inference
 * ```
 * @property allowedInstanceTypes List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
 * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
 * @property bareMetal Indicate whether bare metal instace types should be `included`, `excluded`, or `required`. Default is `excluded`.
 * @property baselineEbsBandwidthMbps Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
 * @property burstablePerformance Indicate whether burstable performance instance types should be `included`, `excluded`, or `required`. Default is `excluded`.
 * @property cpuManufacturers List of CPU manufacturer names. Default is any manufacturer.
 * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
 * ```
 * Valid names:
 * * amazon-web-services
 * * amd
 * * intel
 * ```
 * @property excludedInstanceTypes List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
 * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
 * @property instanceGenerations List of instance generation names. Default is any generation.
 * ```
 * Valid names:
 * * current  - Recommended for best performance.
 * * previous - For existing applications optimized for older instance types.
 * ```
 * @property localStorage Indicate whether instance types with local storage volumes are `included`, `excluded`, or `required`. Default is `included`.
 * @property localStorageTypes List of local storage type names. Default any storage type.
 * ```
 * Value names:
 * * hdd - hard disk drive
 * * ssd - solid state drive
 * ```
 * @property memoryGibPerVcpu Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
 * @property memoryMib Block describing the minimum and maximum amount of memory (MiB). Default is no maximum.
 * @property networkBandwidthGbps Block describing the minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is no minimum or maximum.
 * @property networkInterfaceCount Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
 * @property onDemandMaxPricePercentageOverLowestPrice The price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 20.
 * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
 * @property requireHibernateSupport Indicate whether instance types must support On-Demand Instance Hibernation, either `true` or `false`. Default is `false`.
 * @property spotMaxPricePercentageOverLowestPrice The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 100.
 * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
 * @property totalLocalStorageGb Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
 * @property vcpuCount Block describing the minimum and maximum number of vCPUs. Default is no maximum.
 */
public data class SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirements(
    public val acceleratorCount: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCount? = null,
    public val acceleratorManufacturers: List<String>? = null,
    public val acceleratorNames: List<String>? = null,
    public val acceleratorTotalMemoryMib: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMib? =
        null,
    public val acceleratorTypes: List<String>? = null,
    public val allowedInstanceTypes: List<String>? = null,
    public val bareMetal: String? = null,
    public val baselineEbsBandwidthMbps: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbps? =
        null,
    public val burstablePerformance: String? = null,
    public val cpuManufacturers: List<String>? = null,
    public val excludedInstanceTypes: List<String>? = null,
    public val instanceGenerations: List<String>? = null,
    public val localStorage: String? = null,
    public val localStorageTypes: List<String>? = null,
    public val memoryGibPerVcpu: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpu? = null,
    public val memoryMib: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryMib? =
        null,
    public val networkBandwidthGbps: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbps? = null,
    public val networkInterfaceCount: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCount? = null,
    public val onDemandMaxPricePercentageOverLowestPrice: Int? = null,
    public val requireHibernateSupport: Boolean? = null,
    public val spotMaxPricePercentageOverLowestPrice: Int? = null,
    public val totalLocalStorageGb: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGb? = null,
    public val vcpuCount: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsVcpuCount? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirements): SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirements =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirements(
                acceleratorCount = javaType.acceleratorCount().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCount.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                acceleratorManufacturers = javaType.acceleratorManufacturers().map({ args0 -> args0 }),
                acceleratorNames = javaType.acceleratorNames().map({ args0 -> args0 }),
                acceleratorTotalMemoryMib = javaType.acceleratorTotalMemoryMib().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMib.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                acceleratorTypes = javaType.acceleratorTypes().map({ args0 -> args0 }),
                allowedInstanceTypes = javaType.allowedInstanceTypes().map({ args0 -> args0 }),
                bareMetal = javaType.bareMetal().map({ args0 -> args0 }).orElse(null),
                baselineEbsBandwidthMbps = javaType.baselineEbsBandwidthMbps().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbps.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                burstablePerformance = javaType.burstablePerformance().map({ args0 -> args0 }).orElse(null),
                cpuManufacturers = javaType.cpuManufacturers().map({ args0 -> args0 }),
                excludedInstanceTypes = javaType.excludedInstanceTypes().map({ args0 -> args0 }),
                instanceGenerations = javaType.instanceGenerations().map({ args0 -> args0 }),
                localStorage = javaType.localStorage().map({ args0 -> args0 }).orElse(null),
                localStorageTypes = javaType.localStorageTypes().map({ args0 -> args0 }),
                memoryGibPerVcpu = javaType.memoryGibPerVcpu().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpu.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                memoryMib = javaType.memoryMib().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryMib.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                networkBandwidthGbps = javaType.networkBandwidthGbps().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbps.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                networkInterfaceCount = javaType.networkInterfaceCount().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCount.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                onDemandMaxPricePercentageOverLowestPrice = javaType.onDemandMaxPricePercentageOverLowestPrice().map({ args0 ->
                    args0
                }).orElse(null),
                requireHibernateSupport = javaType.requireHibernateSupport().map({ args0 -> args0 }).orElse(null),
                spotMaxPricePercentageOverLowestPrice = javaType.spotMaxPricePercentageOverLowestPrice().map({ args0 ->
                    args0
                }).orElse(null),
                totalLocalStorageGb = javaType.totalLocalStorageGb().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGb.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                vcpuCount = javaType.vcpuCount().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsVcpuCount.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
