@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enabled Whether Nitro Enclaves will be enabled on the instance. Defaults to `false`.
 * For more information, see the documentation on [Nitro Enclaves](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html).
 */
public data class SpotInstanceRequestEnclaveOptions(
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.SpotInstanceRequestEnclaveOptions): SpotInstanceRequestEnclaveOptions = SpotInstanceRequestEnclaveOptions(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
