@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dnsName The DNS name.
 * @property hostedZoneId The ID of the private hosted zone.
 */
public data class VpcEndpointDnsEntry(
    public val dnsName: String? = null,
    public val hostedZoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.VpcEndpointDnsEntry): VpcEndpointDnsEntry = VpcEndpointDnsEntry(
            dnsName = javaType.dnsName().map({ args0 -> args0 }).orElse(null),
            hostedZoneId = javaType.hostedZoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
