@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dnsRecordIpType The DNS records created for the endpoint. Valid values are `ipv4`, `dualstack`, `service-defined`, and `ipv6`.
 * @property privateDnsOnlyForInboundResolverEndpoint Indicates whether to enable private DNS only for inbound endpoints. This option is available only for services that support both gateway and interface endpoints. It routes traffic that originates from the VPC to the gateway endpoint and traffic that originates from on-premises to the interface endpoint. Default is `false`. Can only be specified if private_dns_enabled is `true`.
 */
public data class VpcEndpointDnsOptions(
    public val dnsRecordIpType: String? = null,
    public val privateDnsOnlyForInboundResolverEndpoint: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.VpcEndpointDnsOptions): VpcEndpointDnsOptions = VpcEndpointDnsOptions(
            dnsRecordIpType = javaType.dnsRecordIpType().map({ args0 -> args0 }).orElse(null),
            privateDnsOnlyForInboundResolverEndpoint = javaType.privateDnsOnlyForInboundResolverEndpoint().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
