@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ipv4 The IPv4 address to assign to the endpoint network interface in the subnet. You must provide an IPv4 address if the VPC endpoint supports IPv4.
 * @property ipv6 The IPv6 address to assign to the endpoint network interface in the subnet. You must provide an IPv6 address if the VPC endpoint supports IPv6.
 * @property subnetId
 */
public data class VpcEndpointSubnetConfiguration(
    public val ipv4: String? = null,
    public val ipv6: String? = null,
    public val subnetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.VpcEndpointSubnetConfiguration): VpcEndpointSubnetConfiguration = VpcEndpointSubnetConfiguration(
            ipv4 = javaType.ipv4().map({ args0 -> args0 }).orElse(null),
            ipv6 = javaType.ipv6().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
