@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property logEnabled Enable or disable VPN tunnel logging feature. The default is `false`.
 * @property logGroupArn The Amazon Resource Name (ARN) of the CloudWatch log group to send logs to.
 * @property logOutputFormat Set log format. Default format is json. Possible values are: `json` and `text`. The default is `json`.
 */
public data class VpnConnectionTunnel1LogOptionsCloudwatchLogOptions(
    public val logEnabled: Boolean? = null,
    public val logGroupArn: String? = null,
    public val logOutputFormat: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.VpnConnectionTunnel1LogOptionsCloudwatchLogOptions): VpnConnectionTunnel1LogOptionsCloudwatchLogOptions =
            VpnConnectionTunnel1LogOptionsCloudwatchLogOptions(
                logEnabled = javaType.logEnabled().map({ args0 -> args0 }).orElse(null),
                logGroupArn = javaType.logGroupArn().map({ args0 -> args0 }).orElse(null),
                logOutputFormat = javaType.logOutputFormat().map({ args0 -> args0 }).orElse(null),
            )
    }
}
