@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property acceptedRouteCount The number of accepted routes.
 * @property certificateArn The Amazon Resource Name (ARN) of the VPN tunnel endpoint certificate.
 * @property lastStatusChange The date and time of the last change in status.
 * @property outsideIpAddress The Internet-routable IP address of the virtual private gateway's outside interface.
 * @property status The status of the VPN tunnel.
 * @property statusMessage If an error occurs, a description of the error.
 */
public data class VpnConnectionVgwTelemetry(
    public val acceptedRouteCount: Int? = null,
    public val certificateArn: String? = null,
    public val lastStatusChange: String? = null,
    public val outsideIpAddress: String? = null,
    public val status: String? = null,
    public val statusMessage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.VpnConnectionVgwTelemetry): VpnConnectionVgwTelemetry = VpnConnectionVgwTelemetry(
            acceptedRouteCount = javaType.acceptedRouteCount().map({ args0 -> args0 }).orElse(null),
            certificateArn = javaType.certificateArn().map({ args0 -> args0 }).orElse(null),
            lastStatusChange = javaType.lastStatusChange().map({ args0 -> args0 }).orElse(null),
            outsideIpAddress = javaType.outsideIpAddress().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            statusMessage = javaType.statusMessage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
