@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AuthorizationRule].
 */
@PulumiTagMarker
public class AuthorizationRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuthorizationRuleArgs = AuthorizationRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuthorizationRuleArgsBuilder.() -> Unit) {
        val builder = AuthorizationRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AuthorizationRule {
        val builtJavaResource = com.pulumi.aws.ec2clientvpn.AuthorizationRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AuthorizationRule(builtJavaResource)
    }
}

/**
 * Provides authorization rules for AWS Client VPN endpoints. For more information on usage, please see the
 * [AWS Client VPN Administrator's Guide](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/what-is.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2clientvpn.AuthorizationRule("example", {
 *     clientVpnEndpointId: exampleAwsEc2ClientVpnEndpoint.id,
 *     targetNetworkCidr: exampleAwsSubnet.cidrBlock,
 *     authorizeAllGroups: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2clientvpn.AuthorizationRule("example",
 *     client_vpn_endpoint_id=example_aws_ec2_client_vpn_endpoint["id"],
 *     target_network_cidr=example_aws_subnet["cidrBlock"],
 *     authorize_all_groups=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2ClientVpn.AuthorizationRule("example", new()
 *     {
 *         ClientVpnEndpointId = exampleAwsEc2ClientVpnEndpoint.Id,
 *         TargetNetworkCidr = exampleAwsSubnet.CidrBlock,
 *         AuthorizeAllGroups = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2clientvpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2clientvpn.NewAuthorizationRule(ctx, "example", &ec2clientvpn.AuthorizationRuleArgs{
 * 			ClientVpnEndpointId: pulumi.Any(exampleAwsEc2ClientVpnEndpoint.Id),
 * 			TargetNetworkCidr:   pulumi.Any(exampleAwsSubnet.CidrBlock),
 * 			AuthorizeAllGroups:  pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2clientvpn.AuthorizationRule;
 * import com.pulumi.aws.ec2clientvpn.AuthorizationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AuthorizationRule("example", AuthorizationRuleArgs.builder()
 *             .clientVpnEndpointId(exampleAwsEc2ClientVpnEndpoint.id())
 *             .targetNetworkCidr(exampleAwsSubnet.cidrBlock())
 *             .authorizeAllGroups(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2clientvpn:AuthorizationRule
 *     properties:
 *       clientVpnEndpointId: ${exampleAwsEc2ClientVpnEndpoint.id}
 *       targetNetworkCidr: ${exampleAwsSubnet.cidrBlock}
 *       authorizeAllGroups: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using the endpoint ID, target network CIDR, and group name:
 * __Using `pulumi import` to import__ AWS Client VPN authorization rules using the endpoint ID and target network CIDR. If there is a specific group name, include that also. All values are separated by a `,`. For example:
 * Using the endpoint ID and target network CIDR:
 * ```sh
 * $ pulumi import aws:ec2clientvpn/authorizationRule:AuthorizationRule example cvpn-endpoint-0ac3a1abbccddd666,10.1.0.0/24
 * ```
 * Using the endpoint ID, target network CIDR, and group name:
 * ```sh
 * $ pulumi import aws:ec2clientvpn/authorizationRule:AuthorizationRule example cvpn-endpoint-0ac3a1abbccddd666,10.1.0.0/24,team-a
 * ```
 */
public class AuthorizationRule internal constructor(
    override val javaResource: com.pulumi.aws.ec2clientvpn.AuthorizationRule,
) : KotlinCustomResource(javaResource, AuthorizationRuleMapper) {
    /**
     * The ID of the group to which the authorization rule grants access. One of `access_group_id` or `authorize_all_groups` must be set.
     */
    public val accessGroupId: Output<String>?
        get() = javaResource.accessGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the authorization rule grants access to all clients. One of `access_group_id` or `authorize_all_groups` must be set.
     */
    public val authorizeAllGroups: Output<Boolean>?
        get() = javaResource.authorizeAllGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Client VPN endpoint.
     */
    public val clientVpnEndpointId: Output<String>
        get() = javaResource.clientVpnEndpointId().applyValue({ args0 -> args0 })

    /**
     * A brief description of the authorization rule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.
     */
    public val targetNetworkCidr: Output<String>
        get() = javaResource.targetNetworkCidr().applyValue({ args0 -> args0 })
}

public object AuthorizationRuleMapper : ResourceMapper<AuthorizationRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2clientvpn.AuthorizationRule::class == javaResource::class

    override fun map(javaResource: Resource): AuthorizationRule = AuthorizationRule(
        javaResource as
            com.pulumi.aws.ec2clientvpn.AuthorizationRule,
    )
}

/**
 * @see [AuthorizationRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AuthorizationRule].
 */
public suspend fun authorizationRule(
    name: String,
    block: suspend AuthorizationRuleResourceBuilder.() -> Unit,
): AuthorizationRule {
    val builder = AuthorizationRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AuthorizationRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun authorizationRule(name: String): AuthorizationRule {
    val builder = AuthorizationRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
