@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin

import com.pulumi.aws.ec2clientvpn.kotlin.outputs.EndpointAuthenticationOption
import com.pulumi.aws.ec2clientvpn.kotlin.outputs.EndpointClientConnectOptions
import com.pulumi.aws.ec2clientvpn.kotlin.outputs.EndpointClientLoginBannerOptions
import com.pulumi.aws.ec2clientvpn.kotlin.outputs.EndpointConnectionLogOptions
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2clientvpn.kotlin.outputs.EndpointAuthenticationOption.Companion.toKotlin as endpointAuthenticationOptionToKotlin
import com.pulumi.aws.ec2clientvpn.kotlin.outputs.EndpointClientConnectOptions.Companion.toKotlin as endpointClientConnectOptionsToKotlin
import com.pulumi.aws.ec2clientvpn.kotlin.outputs.EndpointClientLoginBannerOptions.Companion.toKotlin as endpointClientLoginBannerOptionsToKotlin
import com.pulumi.aws.ec2clientvpn.kotlin.outputs.EndpointConnectionLogOptions.Companion.toKotlin as endpointConnectionLogOptionsToKotlin

/**
 * Builder for [Endpoint].
 */
@PulumiTagMarker
public class EndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointArgs = EndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointArgsBuilder.() -> Unit) {
        val builder = EndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Endpoint {
        val builtJavaResource = com.pulumi.aws.ec2clientvpn.Endpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Endpoint(builtJavaResource)
    }
}

/**
 * Provides an AWS Client VPN endpoint for OpenVPN clients. For more information on usage, please see the
 * [AWS Client VPN Administrator's Guide](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/what-is.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2clientvpn.Endpoint("example", {
 *     description: "clientvpn-example",
 *     serverCertificateArn: cert.arn,
 *     clientCidrBlock: "10.0.0.0/16",
 *     authenticationOptions: [{
 *         type: "certificate-authentication",
 *         rootCertificateChainArn: rootCert.arn,
 *     }],
 *     connectionLogOptions: {
 *         enabled: true,
 *         cloudwatchLogGroup: lg.name,
 *         cloudwatchLogStream: ls.name,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2clientvpn.Endpoint("example",
 *     description="clientvpn-example",
 *     server_certificate_arn=cert["arn"],
 *     client_cidr_block="10.0.0.0/16",
 *     authentication_options=[{
 *         "type": "certificate-authentication",
 *         "root_certificate_chain_arn": root_cert["arn"],
 *     }],
 *     connection_log_options={
 *         "enabled": True,
 *         "cloudwatch_log_group": lg["name"],
 *         "cloudwatch_log_stream": ls["name"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2ClientVpn.Endpoint("example", new()
 *     {
 *         Description = "clientvpn-example",
 *         ServerCertificateArn = cert.Arn,
 *         ClientCidrBlock = "10.0.0.0/16",
 *         AuthenticationOptions = new[]
 *         {
 *             new Aws.Ec2ClientVpn.Inputs.EndpointAuthenticationOptionArgs
 *             {
 *                 Type = "certificate-authentication",
 *                 RootCertificateChainArn = rootCert.Arn,
 *             },
 *         },
 *         ConnectionLogOptions = new Aws.Ec2ClientVpn.Inputs.EndpointConnectionLogOptionsArgs
 *         {
 *             Enabled = true,
 *             CloudwatchLogGroup = lg.Name,
 *             CloudwatchLogStream = ls.Name,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2clientvpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2clientvpn.NewEndpoint(ctx, "example", &ec2clientvpn.EndpointArgs{
 * 			Description:          pulumi.String("clientvpn-example"),
 * 			ServerCertificateArn: pulumi.Any(cert.Arn),
 * 			ClientCidrBlock:      pulumi.String("10.0.0.0/16"),
 * 			AuthenticationOptions: ec2clientvpn.EndpointAuthenticationOptionArray{
 * 				&ec2clientvpn.EndpointAuthenticationOptionArgs{
 * 					Type:                    pulumi.String("certificate-authentication"),
 * 					RootCertificateChainArn: pulumi.Any(rootCert.Arn),
 * 				},
 * 			},
 * 			ConnectionLogOptions: &ec2clientvpn.EndpointConnectionLogOptionsArgs{
 * 				Enabled:             pulumi.Bool(true),
 * 				CloudwatchLogGroup:  pulumi.Any(lg.Name),
 * 				CloudwatchLogStream: pulumi.Any(ls.Name),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2clientvpn.Endpoint;
 * import com.pulumi.aws.ec2clientvpn.EndpointArgs;
 * import com.pulumi.aws.ec2clientvpn.inputs.EndpointAuthenticationOptionArgs;
 * import com.pulumi.aws.ec2clientvpn.inputs.EndpointConnectionLogOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Endpoint("example", EndpointArgs.builder()
 *             .description("clientvpn-example")
 *             .serverCertificateArn(cert.arn())
 *             .clientCidrBlock("10.0.0.0/16")
 *             .authenticationOptions(EndpointAuthenticationOptionArgs.builder()
 *                 .type("certificate-authentication")
 *                 .rootCertificateChainArn(rootCert.arn())
 *                 .build())
 *             .connectionLogOptions(EndpointConnectionLogOptionsArgs.builder()
 *                 .enabled(true)
 *                 .cloudwatchLogGroup(lg.name())
 *                 .cloudwatchLogStream(ls.name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2clientvpn:Endpoint
 *     properties:
 *       description: clientvpn-example
 *       serverCertificateArn: ${cert.arn}
 *       clientCidrBlock: 10.0.0.0/16
 *       authenticationOptions:
 *         - type: certificate-authentication
 *           rootCertificateChainArn: ${rootCert.arn}
 *       connectionLogOptions:
 *         enabled: true
 *         cloudwatchLogGroup: ${lg.name}
 *         cloudwatchLogStream: ${ls.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS Client VPN endpoints using the `id` value found via `aws ec2 describe-client-vpn-endpoints`. For example:
 * ```sh
 * $ pulumi import aws:ec2clientvpn/endpoint:Endpoint example cvpn-endpoint-0ac3a1abbccddd666
 * ```
 */
public class Endpoint internal constructor(
    override val javaResource: com.pulumi.aws.ec2clientvpn.Endpoint,
) : KotlinCustomResource(javaResource, EndpointMapper) {
    /**
     * The ARN of the Client VPN endpoint.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Information about the authentication method to be used to authenticate clients.
     */
    public val authenticationOptions: Output<List<EndpointAuthenticationOption>>
        get() = javaResource.authenticationOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointAuthenticationOptionToKotlin(args0) })
            })
        })

    /**
     * The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
     */
    public val clientCidrBlock: Output<String>
        get() = javaResource.clientCidrBlock().applyValue({ args0 -> args0 })

    /**
     * The options for managing connection authorization for new client connections.
     */
    public val clientConnectOptions: Output<EndpointClientConnectOptions>
        get() = javaResource.clientConnectOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                endpointClientConnectOptionsToKotlin(args0)
            })
        })

    /**
     * Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
     */
    public val clientLoginBannerOptions: Output<EndpointClientLoginBannerOptions>
        get() = javaResource.clientLoginBannerOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                endpointClientLoginBannerOptionsToKotlin(args0)
            })
        })

    /**
     * Information about the client connection logging options.
     */
    public val connectionLogOptions: Output<EndpointConnectionLogOptions>
        get() = javaResource.connectionLogOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                endpointConnectionLogOptionsToKotlin(args0)
            })
        })

    /**
     * A brief description of the Client VPN endpoint.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The DNS name to be used by clients when establishing their VPN session.
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
     */
    public val dnsServers: Output<List<String>>?
        get() = javaResource.dnsServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
     */
    public val selfServicePortal: Output<String>?
        get() = javaResource.selfServicePortal().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The URL of the self-service portal.
     */
    public val selfServicePortalUrl: Output<String>
        get() = javaResource.selfServicePortalUrl().applyValue({ args0 -> args0 })

    /**
     * The ARN of the ACM server certificate.
     */
    public val serverCertificateArn: Output<String>
        get() = javaResource.serverCertificateArn().applyValue({ args0 -> args0 })

    /**
     * The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
     */
    public val sessionTimeoutHours: Output<Int>?
        get() = javaResource.sessionTimeoutHours().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
     */
    public val splitTunnel: Output<Boolean>?
        get() = javaResource.splitTunnel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The transport protocol to be used by the VPN session. Default value is `udp`.
     */
    public val transportProtocol: Output<String>?
        get() = javaResource.transportProtocol().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
     */
    public val vpnPort: Output<Int>?
        get() = javaResource.vpnPort().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object EndpointMapper : ResourceMapper<Endpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2clientvpn.Endpoint::class == javaResource::class

    override fun map(javaResource: Resource): Endpoint = Endpoint(
        javaResource as
            com.pulumi.aws.ec2clientvpn.Endpoint,
    )
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Endpoint].
 */
public suspend fun endpoint(name: String, block: suspend EndpointResourceBuilder.() -> Unit): Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpoint(name: String): Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
