@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin

import com.pulumi.aws.ec2clientvpn.EndpointArgs.builder
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointAuthenticationOptionArgs
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointAuthenticationOptionArgsBuilder
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointClientConnectOptionsArgs
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointClientConnectOptionsArgsBuilder
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointClientLoginBannerOptionsArgs
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointClientLoginBannerOptionsArgsBuilder
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointConnectionLogOptionsArgs
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointConnectionLogOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Client VPN endpoint for OpenVPN clients. For more information on usage, please see the
 * [AWS Client VPN Administrator's Guide](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/what-is.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2clientvpn.Endpoint("example", {
 *     description: "clientvpn-example",
 *     serverCertificateArn: cert.arn,
 *     clientCidrBlock: "10.0.0.0/16",
 *     authenticationOptions: [{
 *         type: "certificate-authentication",
 *         rootCertificateChainArn: rootCert.arn,
 *     }],
 *     connectionLogOptions: {
 *         enabled: true,
 *         cloudwatchLogGroup: lg.name,
 *         cloudwatchLogStream: ls.name,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2clientvpn.Endpoint("example",
 *     description="clientvpn-example",
 *     server_certificate_arn=cert["arn"],
 *     client_cidr_block="10.0.0.0/16",
 *     authentication_options=[{
 *         "type": "certificate-authentication",
 *         "root_certificate_chain_arn": root_cert["arn"],
 *     }],
 *     connection_log_options={
 *         "enabled": True,
 *         "cloudwatch_log_group": lg["name"],
 *         "cloudwatch_log_stream": ls["name"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2ClientVpn.Endpoint("example", new()
 *     {
 *         Description = "clientvpn-example",
 *         ServerCertificateArn = cert.Arn,
 *         ClientCidrBlock = "10.0.0.0/16",
 *         AuthenticationOptions = new[]
 *         {
 *             new Aws.Ec2ClientVpn.Inputs.EndpointAuthenticationOptionArgs
 *             {
 *                 Type = "certificate-authentication",
 *                 RootCertificateChainArn = rootCert.Arn,
 *             },
 *         },
 *         ConnectionLogOptions = new Aws.Ec2ClientVpn.Inputs.EndpointConnectionLogOptionsArgs
 *         {
 *             Enabled = true,
 *             CloudwatchLogGroup = lg.Name,
 *             CloudwatchLogStream = ls.Name,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2clientvpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2clientvpn.NewEndpoint(ctx, "example", &ec2clientvpn.EndpointArgs{
 * 			Description:          pulumi.String("clientvpn-example"),
 * 			ServerCertificateArn: pulumi.Any(cert.Arn),
 * 			ClientCidrBlock:      pulumi.String("10.0.0.0/16"),
 * 			AuthenticationOptions: ec2clientvpn.EndpointAuthenticationOptionArray{
 * 				&ec2clientvpn.EndpointAuthenticationOptionArgs{
 * 					Type:                    pulumi.String("certificate-authentication"),
 * 					RootCertificateChainArn: pulumi.Any(rootCert.Arn),
 * 				},
 * 			},
 * 			ConnectionLogOptions: &ec2clientvpn.EndpointConnectionLogOptionsArgs{
 * 				Enabled:             pulumi.Bool(true),
 * 				CloudwatchLogGroup:  pulumi.Any(lg.Name),
 * 				CloudwatchLogStream: pulumi.Any(ls.Name),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2clientvpn.Endpoint;
 * import com.pulumi.aws.ec2clientvpn.EndpointArgs;
 * import com.pulumi.aws.ec2clientvpn.inputs.EndpointAuthenticationOptionArgs;
 * import com.pulumi.aws.ec2clientvpn.inputs.EndpointConnectionLogOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Endpoint("example", EndpointArgs.builder()
 *             .description("clientvpn-example")
 *             .serverCertificateArn(cert.arn())
 *             .clientCidrBlock("10.0.0.0/16")
 *             .authenticationOptions(EndpointAuthenticationOptionArgs.builder()
 *                 .type("certificate-authentication")
 *                 .rootCertificateChainArn(rootCert.arn())
 *                 .build())
 *             .connectionLogOptions(EndpointConnectionLogOptionsArgs.builder()
 *                 .enabled(true)
 *                 .cloudwatchLogGroup(lg.name())
 *                 .cloudwatchLogStream(ls.name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2clientvpn:Endpoint
 *     properties:
 *       description: clientvpn-example
 *       serverCertificateArn: ${cert.arn}
 *       clientCidrBlock: 10.0.0.0/16
 *       authenticationOptions:
 *         - type: certificate-authentication
 *           rootCertificateChainArn: ${rootCert.arn}
 *       connectionLogOptions:
 *         enabled: true
 *         cloudwatchLogGroup: ${lg.name}
 *         cloudwatchLogStream: ${ls.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS Client VPN endpoints using the `id` value found via `aws ec2 describe-client-vpn-endpoints`. For example:
 * ```sh
 * $ pulumi import aws:ec2clientvpn/endpoint:Endpoint example cvpn-endpoint-0ac3a1abbccddd666
 * ```
 * @property authenticationOptions Information about the authentication method to be used to authenticate clients.
 * @property clientCidrBlock The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
 * @property clientConnectOptions The options for managing connection authorization for new client connections.
 * @property clientLoginBannerOptions Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
 * @property connectionLogOptions Information about the client connection logging options.
 * @property description A brief description of the Client VPN endpoint.
 * @property dnsServers Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
 * @property securityGroupIds The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
 * @property selfServicePortal Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
 * @property serverCertificateArn The ARN of the ACM server certificate.
 * @property sessionTimeoutHours The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
 * @property splitTunnel Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
 * @property tags A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transportProtocol The transport protocol to be used by the VPN session. Default value is `udp`.
 * @property vpcId The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
 * @property vpnPort The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
 */
public data class EndpointArgs(
    public val authenticationOptions: Output<List<EndpointAuthenticationOptionArgs>>? = null,
    public val clientCidrBlock: Output<String>? = null,
    public val clientConnectOptions: Output<EndpointClientConnectOptionsArgs>? = null,
    public val clientLoginBannerOptions: Output<EndpointClientLoginBannerOptionsArgs>? = null,
    public val connectionLogOptions: Output<EndpointConnectionLogOptionsArgs>? = null,
    public val description: Output<String>? = null,
    public val dnsServers: Output<List<String>>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val selfServicePortal: Output<String>? = null,
    public val serverCertificateArn: Output<String>? = null,
    public val sessionTimeoutHours: Output<Int>? = null,
    public val splitTunnel: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transportProtocol: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vpnPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2clientvpn.EndpointArgs> {
    override fun toJava(): com.pulumi.aws.ec2clientvpn.EndpointArgs =
        com.pulumi.aws.ec2clientvpn.EndpointArgs.builder()
            .authenticationOptions(
                authenticationOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .clientCidrBlock(clientCidrBlock?.applyValue({ args0 -> args0 }))
            .clientConnectOptions(
                clientConnectOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clientLoginBannerOptions(
                clientLoginBannerOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .connectionLogOptions(
                connectionLogOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .selfServicePortal(selfServicePortal?.applyValue({ args0 -> args0 }))
            .serverCertificateArn(serverCertificateArn?.applyValue({ args0 -> args0 }))
            .sessionTimeoutHours(sessionTimeoutHours?.applyValue({ args0 -> args0 }))
            .splitTunnel(splitTunnel?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transportProtocol(transportProtocol?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vpnPort(vpnPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var authenticationOptions: Output<List<EndpointAuthenticationOptionArgs>>? = null

    private var clientCidrBlock: Output<String>? = null

    private var clientConnectOptions: Output<EndpointClientConnectOptionsArgs>? = null

    private var clientLoginBannerOptions: Output<EndpointClientLoginBannerOptionsArgs>? = null

    private var connectionLogOptions: Output<EndpointConnectionLogOptionsArgs>? = null

    private var description: Output<String>? = null

    private var dnsServers: Output<List<String>>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var selfServicePortal: Output<String>? = null

    private var serverCertificateArn: Output<String>? = null

    private var sessionTimeoutHours: Output<Int>? = null

    private var splitTunnel: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transportProtocol: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vpnPort: Output<Int>? = null

    /**
     * @param value Information about the authentication method to be used to authenticate clients.
     */
    @JvmName("obbvpgrjrkaxatgw")
    public suspend fun authenticationOptions(`value`: Output<List<EndpointAuthenticationOptionArgs>>) {
        this.authenticationOptions = value
    }

    @JvmName("xrwsxoobcmwptvws")
    public suspend fun authenticationOptions(vararg values: Output<EndpointAuthenticationOptionArgs>) {
        this.authenticationOptions = Output.all(values.asList())
    }

    /**
     * @param values Information about the authentication method to be used to authenticate clients.
     */
    @JvmName("cqwldbtaiavswaov")
    public suspend fun authenticationOptions(values: List<Output<EndpointAuthenticationOptionArgs>>) {
        this.authenticationOptions = Output.all(values)
    }

    /**
     * @param value The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
     */
    @JvmName("vlheajseyvmicgpf")
    public suspend fun clientCidrBlock(`value`: Output<String>) {
        this.clientCidrBlock = value
    }

    /**
     * @param value The options for managing connection authorization for new client connections.
     */
    @JvmName("ynwvcjqsaikxhwgs")
    public suspend fun clientConnectOptions(`value`: Output<EndpointClientConnectOptionsArgs>) {
        this.clientConnectOptions = value
    }

    /**
     * @param value Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
     */
    @JvmName("rvjpjbsylqltlipe")
    public suspend fun clientLoginBannerOptions(`value`: Output<EndpointClientLoginBannerOptionsArgs>) {
        this.clientLoginBannerOptions = value
    }

    /**
     * @param value Information about the client connection logging options.
     */
    @JvmName("wwcuopwfddlppwer")
    public suspend fun connectionLogOptions(`value`: Output<EndpointConnectionLogOptionsArgs>) {
        this.connectionLogOptions = value
    }

    /**
     * @param value A brief description of the Client VPN endpoint.
     */
    @JvmName("axcesuiphakrwufc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
     */
    @JvmName("kfyabbqrgchnhusl")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("qlquxpujhdmapudo")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
     */
    @JvmName("xksegcpkuwsmiqeq")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
     */
    @JvmName("ejoukdbmwmwrbcpx")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("nnrqtqtnvwwraryd")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
     */
    @JvmName("qblypdhheiihbqsm")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
     */
    @JvmName("ovhbagrmrgdnwymt")
    public suspend fun selfServicePortal(`value`: Output<String>) {
        this.selfServicePortal = value
    }

    /**
     * @param value The ARN of the ACM server certificate.
     */
    @JvmName("noucyammrpfjkfdc")
    public suspend fun serverCertificateArn(`value`: Output<String>) {
        this.serverCertificateArn = value
    }

    /**
     * @param value The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
     */
    @JvmName("ugcqujhthdisnjgu")
    public suspend fun sessionTimeoutHours(`value`: Output<Int>) {
        this.sessionTimeoutHours = value
    }

    /**
     * @param value Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
     */
    @JvmName("fakuxthfdqmopxso")
    public suspend fun splitTunnel(`value`: Output<Boolean>) {
        this.splitTunnel = value
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vbvnybmktrsphmae")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The transport protocol to be used by the VPN session. Default value is `udp`.
     */
    @JvmName("ttqbqtwofikipyqb")
    public suspend fun transportProtocol(`value`: Output<String>) {
        this.transportProtocol = value
    }

    /**
     * @param value The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
     */
    @JvmName("lqbrobxfnyuglfnf")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
     */
    @JvmName("ndbltsgxyxgoxvpm")
    public suspend fun vpnPort(`value`: Output<Int>) {
        this.vpnPort = value
    }

    /**
     * @param value Information about the authentication method to be used to authenticate clients.
     */
    @JvmName("vcrtmcnbpeqgklwj")
    public suspend fun authenticationOptions(`value`: List<EndpointAuthenticationOptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationOptions = mapped
    }

    /**
     * @param argument Information about the authentication method to be used to authenticate clients.
     */
    @JvmName("cqnulcamyajisvuf")
    public suspend fun authenticationOptions(argument: List<suspend EndpointAuthenticationOptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointAuthenticationOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authenticationOptions = mapped
    }

    /**
     * @param argument Information about the authentication method to be used to authenticate clients.
     */
    @JvmName("yulnybgthvtpdtpf")
    public suspend fun authenticationOptions(vararg argument: suspend EndpointAuthenticationOptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EndpointAuthenticationOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authenticationOptions = mapped
    }

    /**
     * @param argument Information about the authentication method to be used to authenticate clients.
     */
    @JvmName("gbgphlbexfuwnkgb")
    public suspend fun authenticationOptions(argument: suspend EndpointAuthenticationOptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EndpointAuthenticationOptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.authenticationOptions = mapped
    }

    /**
     * @param values Information about the authentication method to be used to authenticate clients.
     */
    @JvmName("yeutujdavqghhbrc")
    public suspend fun authenticationOptions(vararg values: EndpointAuthenticationOptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationOptions = mapped
    }

    /**
     * @param value The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
     */
    @JvmName("cmswidfhadcsgtjg")
    public suspend fun clientCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCidrBlock = mapped
    }

    /**
     * @param value The options for managing connection authorization for new client connections.
     */
    @JvmName("lkqoxrpkooemddex")
    public suspend fun clientConnectOptions(`value`: EndpointClientConnectOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientConnectOptions = mapped
    }

    /**
     * @param argument The options for managing connection authorization for new client connections.
     */
    @JvmName("vvwabuamfqwqnafp")
    public suspend fun clientConnectOptions(argument: suspend EndpointClientConnectOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointClientConnectOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientConnectOptions = mapped
    }

    /**
     * @param value Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
     */
    @JvmName("pvfbduwjdhwgqccg")
    public suspend fun clientLoginBannerOptions(`value`: EndpointClientLoginBannerOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientLoginBannerOptions = mapped
    }

    /**
     * @param argument Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
     */
    @JvmName("rakgruadmefvuevt")
    public suspend fun clientLoginBannerOptions(argument: suspend EndpointClientLoginBannerOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointClientLoginBannerOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.clientLoginBannerOptions = mapped
    }

    /**
     * @param value Information about the client connection logging options.
     */
    @JvmName("bgtcrimlopktxibx")
    public suspend fun connectionLogOptions(`value`: EndpointConnectionLogOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionLogOptions = mapped
    }

    /**
     * @param argument Information about the client connection logging options.
     */
    @JvmName("sdcxmwysphcasilu")
    public suspend fun connectionLogOptions(argument: suspend EndpointConnectionLogOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointConnectionLogOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectionLogOptions = mapped
    }

    /**
     * @param value A brief description of the Client VPN endpoint.
     */
    @JvmName("afbcrhllsmakthjo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
     */
    @JvmName("citxqkkabkojumfl")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
     */
    @JvmName("hvhumolmyycrblwv")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param value The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
     */
    @JvmName("ndmiepddcoslcnjq")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
     */
    @JvmName("nugvstfrgndgynxx")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
     */
    @JvmName("mnlmwiatiwwmatec")
    public suspend fun selfServicePortal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selfServicePortal = mapped
    }

    /**
     * @param value The ARN of the ACM server certificate.
     */
    @JvmName("sjtsvabahyyarrxg")
    public suspend fun serverCertificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCertificateArn = mapped
    }

    /**
     * @param value The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
     */
    @JvmName("bsnctekabwqasxde")
    public suspend fun sessionTimeoutHours(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionTimeoutHours = mapped
    }

    /**
     * @param value Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
     */
    @JvmName("alrdmtxllfxiaoxl")
    public suspend fun splitTunnel(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.splitTunnel = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pfgnhbtohsxnppef")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("khxmhmcglbwgggkg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The transport protocol to be used by the VPN session. Default value is `udp`.
     */
    @JvmName("dmapuxhewiotmcpt")
    public suspend fun transportProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportProtocol = mapped
    }

    /**
     * @param value The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
     */
    @JvmName("ovcpkxcgbufmbinf")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
     */
    @JvmName("hosysiuposfbvsig")
    public suspend fun vpnPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnPort = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        authenticationOptions = authenticationOptions,
        clientCidrBlock = clientCidrBlock,
        clientConnectOptions = clientConnectOptions,
        clientLoginBannerOptions = clientLoginBannerOptions,
        connectionLogOptions = connectionLogOptions,
        description = description,
        dnsServers = dnsServers,
        securityGroupIds = securityGroupIds,
        selfServicePortal = selfServicePortal,
        serverCertificateArn = serverCertificateArn,
        sessionTimeoutHours = sessionTimeoutHours,
        splitTunnel = splitTunnel,
        tags = tags,
        transportProtocol = transportProtocol,
        vpcId = vpcId,
        vpnPort = vpnPort,
    )
}
