@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NetworkAssociation].
 */
@PulumiTagMarker
public class NetworkAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkAssociationArgs = NetworkAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkAssociationArgsBuilder.() -> Unit) {
        val builder = NetworkAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkAssociation {
        val builtJavaResource = com.pulumi.aws.ec2clientvpn.NetworkAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkAssociation(builtJavaResource)
    }
}

/**
 * Provides network associations for AWS Client VPN endpoints. For more information on usage, please see the
 * [AWS Client VPN Administrator's Guide](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/what-is.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2clientvpn.NetworkAssociation("example", {
 *     clientVpnEndpointId: exampleAwsEc2ClientVpnEndpoint.id,
 *     subnetId: exampleAwsSubnet.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2clientvpn.NetworkAssociation("example",
 *     client_vpn_endpoint_id=example_aws_ec2_client_vpn_endpoint["id"],
 *     subnet_id=example_aws_subnet["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2ClientVpn.NetworkAssociation("example", new()
 *     {
 *         ClientVpnEndpointId = exampleAwsEc2ClientVpnEndpoint.Id,
 *         SubnetId = exampleAwsSubnet.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2clientvpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2clientvpn.NewNetworkAssociation(ctx, "example", &ec2clientvpn.NetworkAssociationArgs{
 * 			ClientVpnEndpointId: pulumi.Any(exampleAwsEc2ClientVpnEndpoint.Id),
 * 			SubnetId:            pulumi.Any(exampleAwsSubnet.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2clientvpn.NetworkAssociation;
 * import com.pulumi.aws.ec2clientvpn.NetworkAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NetworkAssociation("example", NetworkAssociationArgs.builder()
 *             .clientVpnEndpointId(exampleAwsEc2ClientVpnEndpoint.id())
 *             .subnetId(exampleAwsSubnet.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2clientvpn:NetworkAssociation
 *     properties:
 *       clientVpnEndpointId: ${exampleAwsEc2ClientVpnEndpoint.id}
 *       subnetId: ${exampleAwsSubnet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS Client VPN network associations using the endpoint ID and the association ID. Values are separated by a `,`. For example:
 * ```sh
 * $ pulumi import aws:ec2clientvpn/networkAssociation:NetworkAssociation example cvpn-endpoint-0ac3a1abbccddd666,cvpn-assoc-0b8db902465d069ad
 * ```
 */
public class NetworkAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2clientvpn.NetworkAssociation,
) : KotlinCustomResource(javaResource, NetworkAssociationMapper) {
    /**
     * The unique ID of the target network association.
     */
    public val associationId: Output<String>
        get() = javaResource.associationId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Client VPN endpoint.
     */
    public val clientVpnEndpointId: Output<String>
        get() = javaResource.clientVpnEndpointId().applyValue({ args0 -> args0 })

    /**
     * The ID of the subnet to associate with the Client VPN endpoint.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC in which the target subnet is located.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object NetworkAssociationMapper : ResourceMapper<NetworkAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2clientvpn.NetworkAssociation::class == javaResource::class

    override fun map(javaResource: Resource): NetworkAssociation = NetworkAssociation(
        javaResource as
            com.pulumi.aws.ec2clientvpn.NetworkAssociation,
    )
}

/**
 * @see [NetworkAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkAssociation].
 */
public suspend fun networkAssociation(
    name: String,
    block: suspend NetworkAssociationResourceBuilder.() -> Unit,
): NetworkAssociation {
    val builder = NetworkAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkAssociation(name: String): NetworkAssociation {
    val builder = NetworkAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
