@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin

import com.pulumi.aws.ec2clientvpn.NetworkAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides network associations for AWS Client VPN endpoints. For more information on usage, please see the
 * [AWS Client VPN Administrator's Guide](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/what-is.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2clientvpn.NetworkAssociation("example", {
 *     clientVpnEndpointId: exampleAwsEc2ClientVpnEndpoint.id,
 *     subnetId: exampleAwsSubnet.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2clientvpn.NetworkAssociation("example",
 *     client_vpn_endpoint_id=example_aws_ec2_client_vpn_endpoint["id"],
 *     subnet_id=example_aws_subnet["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2ClientVpn.NetworkAssociation("example", new()
 *     {
 *         ClientVpnEndpointId = exampleAwsEc2ClientVpnEndpoint.Id,
 *         SubnetId = exampleAwsSubnet.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2clientvpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2clientvpn.NewNetworkAssociation(ctx, "example", &ec2clientvpn.NetworkAssociationArgs{
 * 			ClientVpnEndpointId: pulumi.Any(exampleAwsEc2ClientVpnEndpoint.Id),
 * 			SubnetId:            pulumi.Any(exampleAwsSubnet.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2clientvpn.NetworkAssociation;
 * import com.pulumi.aws.ec2clientvpn.NetworkAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NetworkAssociation("example", NetworkAssociationArgs.builder()
 *             .clientVpnEndpointId(exampleAwsEc2ClientVpnEndpoint.id())
 *             .subnetId(exampleAwsSubnet.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2clientvpn:NetworkAssociation
 *     properties:
 *       clientVpnEndpointId: ${exampleAwsEc2ClientVpnEndpoint.id}
 *       subnetId: ${exampleAwsSubnet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS Client VPN network associations using the endpoint ID and the association ID. Values are separated by a `,`. For example:
 * ```sh
 * $ pulumi import aws:ec2clientvpn/networkAssociation:NetworkAssociation example cvpn-endpoint-0ac3a1abbccddd666,cvpn-assoc-0b8db902465d069ad
 * ```
 * @property clientVpnEndpointId The ID of the Client VPN endpoint.
 * @property subnetId The ID of the subnet to associate with the Client VPN endpoint.
 */
public data class NetworkAssociationArgs(
    public val clientVpnEndpointId: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2clientvpn.NetworkAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2clientvpn.NetworkAssociationArgs =
        com.pulumi.aws.ec2clientvpn.NetworkAssociationArgs.builder()
            .clientVpnEndpointId(clientVpnEndpointId?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAssociationArgs].
 */
@PulumiTagMarker
public class NetworkAssociationArgsBuilder internal constructor() {
    private var clientVpnEndpointId: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The ID of the Client VPN endpoint.
     */
    @JvmName("hxlqaqiijjkijcrp")
    public suspend fun clientVpnEndpointId(`value`: Output<String>) {
        this.clientVpnEndpointId = value
    }

    /**
     * @param value The ID of the subnet to associate with the Client VPN endpoint.
     */
    @JvmName("gevkwesvrkjlqopk")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The ID of the Client VPN endpoint.
     */
    @JvmName("oahncmtsfpdonntd")
    public suspend fun clientVpnEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientVpnEndpointId = mapped
    }

    /**
     * @param value The ID of the subnet to associate with the Client VPN endpoint.
     */
    @JvmName("efybawwnyoidfrkl")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): NetworkAssociationArgs = NetworkAssociationArgs(
        clientVpnEndpointId = clientVpnEndpointId,
        subnetId = subnetId,
    )
}
