@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin.inputs

import com.pulumi.aws.ec2clientvpn.inputs.EndpointClientLoginBannerOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bannerText Customizable text that will be displayed in a banner on AWS provided clients when a VPN session is established. UTF-8 encoded characters only. Maximum of 1400 characters.
 * @property enabled Enable or disable a customizable text banner that will be displayed on AWS provided clients when a VPN session is established. The default is `false` (not enabled).
 */
public data class EndpointClientLoginBannerOptionsArgs(
    public val bannerText: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2clientvpn.inputs.EndpointClientLoginBannerOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2clientvpn.inputs.EndpointClientLoginBannerOptionsArgs =
        com.pulumi.aws.ec2clientvpn.inputs.EndpointClientLoginBannerOptionsArgs.builder()
            .bannerText(bannerText?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointClientLoginBannerOptionsArgs].
 */
@PulumiTagMarker
public class EndpointClientLoginBannerOptionsArgsBuilder internal constructor() {
    private var bannerText: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value Customizable text that will be displayed in a banner on AWS provided clients when a VPN session is established. UTF-8 encoded characters only. Maximum of 1400 characters.
     */
    @JvmName("wcqrpsyugpiplclh")
    public suspend fun bannerText(`value`: Output<String>) {
        this.bannerText = value
    }

    /**
     * @param value Enable or disable a customizable text banner that will be displayed on AWS provided clients when a VPN session is established. The default is `false` (not enabled).
     */
    @JvmName("deohwdqfwfbmisuh")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Customizable text that will be displayed in a banner on AWS provided clients when a VPN session is established. UTF-8 encoded characters only. Maximum of 1400 characters.
     */
    @JvmName("qmbmpwaxsduyxlvi")
    public suspend fun bannerText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bannerText = mapped
    }

    /**
     * @param value Enable or disable a customizable text banner that will be displayed on AWS provided clients when a VPN session is established. The default is `false` (not enabled).
     */
    @JvmName("txabmjpbaevlhdmv")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): EndpointClientLoginBannerOptionsArgs = EndpointClientLoginBannerOptionsArgs(
        bannerText = bannerText,
        enabled = enabled,
    )
}
