@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin.inputs

import com.pulumi.aws.ec2clientvpn.inputs.GetEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEndpoint.
 * @property clientVpnEndpointId ID of the Client VPN endpoint.
 * @property filters One or more configuration blocks containing name-values filters. Detailed below.
 * @property tags Map of tags, each pair of which must exactly match a pair on the desired endpoint.
 */
public data class GetEndpointPlainArgs(
    public val clientVpnEndpointId: String? = null,
    public val filters: List<GetEndpointFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2clientvpn.inputs.GetEndpointPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2clientvpn.inputs.GetEndpointPlainArgs =
        com.pulumi.aws.ec2clientvpn.inputs.GetEndpointPlainArgs.builder()
            .clientVpnEndpointId(clientVpnEndpointId?.let({ args0 -> args0 }))
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetEndpointPlainArgsBuilder internal constructor() {
    private var clientVpnEndpointId: String? = null

    private var filters: List<GetEndpointFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID of the Client VPN endpoint.
     */
    @JvmName("sawhnmvkdkojddoa")
    public suspend fun clientVpnEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.clientVpnEndpointId = mapped
    }

    /**
     * @param value One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("bgapyobomllvabdi")
    public suspend fun filters(`value`: List<GetEndpointFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("trhdnhwxgvpqofdh")
    public suspend fun filters(argument: List<suspend GetEndpointFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetEndpointFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("bqoogawieundxrqn")
    public suspend fun filters(vararg argument: suspend GetEndpointFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetEndpointFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("gpulrhiiblamxyoo")
    public suspend fun filters(argument: suspend GetEndpointFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetEndpointFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("krnfjkyhnoeiojdu")
    public suspend fun filters(vararg values: GetEndpointFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match a pair on the desired endpoint.
     */
    @JvmName("gcsefopionfpahqd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match a pair on the desired endpoint.
     */
    @JvmName("tkrxtfdgkmlmdiwm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetEndpointPlainArgs = GetEndpointPlainArgs(
        clientVpnEndpointId = clientVpnEndpointId,
        filters = filters,
        tags = tags,
    )
}
