@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Indicates whether client connect options are enabled. The default is `false` (not enabled).
 * @property lambdaFunctionArn The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.
 */
public data class EndpointClientConnectOptions(
    public val enabled: Boolean? = null,
    public val lambdaFunctionArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2clientvpn.outputs.EndpointClientConnectOptions): EndpointClientConnectOptions = EndpointClientConnectOptions(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            lambdaFunctionArn = javaType.lambdaFunctionArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
