@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cloudwatchLogGroup The name of the CloudWatch Logs log group.
 * @property cloudwatchLogStream The name of the CloudWatch Logs log stream to which the connection data is published.
 * @property enabled Indicates whether connection logging is enabled.
 */
public data class EndpointConnectionLogOptions(
    public val cloudwatchLogGroup: String? = null,
    public val cloudwatchLogStream: String? = null,
    public val enabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2clientvpn.outputs.EndpointConnectionLogOptions): EndpointConnectionLogOptions = EndpointConnectionLogOptions(
            cloudwatchLogGroup = javaType.cloudwatchLogGroup().map({ args0 -> args0 }).orElse(null),
            cloudwatchLogStream = javaType.cloudwatchLogStream().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
        )
    }
}
