@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getEndpoint.
 * @property arn The ARN of the Client VPN endpoint.
 * @property authenticationOptions Information about the authentication method used by the Client VPN endpoint.
 * @property clientCidrBlock IPv4 address range, in CIDR notation, from which client IP addresses are assigned.
 * @property clientConnectOptions The options for managing connection authorization for new client connections.
 * @property clientLoginBannerOptions Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
 * @property clientVpnEndpointId
 * @property connectionLogOptions Information about the client connection logging options for the Client VPN endpoint.
 * @property description Brief description of the endpoint.
 * @property dnsName DNS name to be used by clients when connecting to the Client VPN endpoint.
 * @property dnsServers Information about the DNS servers to be used for DNS resolution.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property securityGroupIds IDs of the security groups for the target network associated with the Client VPN endpoint.
 * @property selfServicePortal Whether the self-service portal for the Client VPN endpoint is enabled.
 * @property selfServicePortalUrl The URL of the self-service portal.
 * @property serverCertificateArn The ARN of the server certificate.
 * @property sessionTimeoutHours The maximum VPN session duration time in hours.
 * @property splitTunnel Whether split-tunnel is enabled in the AWS Client VPN endpoint.
 * @property tags
 * @property transportProtocol Transport protocol used by the Client VPN endpoint.
 * @property vpcId ID of the VPC associated with the Client VPN endpoint.
 * @property vpnPort Port number for the Client VPN endpoint.
 */
public data class GetEndpointResult(
    public val arn: String,
    public val authenticationOptions: List<GetEndpointAuthenticationOption>,
    public val clientCidrBlock: String,
    public val clientConnectOptions: List<GetEndpointClientConnectOption>,
    public val clientLoginBannerOptions: List<GetEndpointClientLoginBannerOption>,
    public val clientVpnEndpointId: String,
    public val connectionLogOptions: List<GetEndpointConnectionLogOption>,
    public val description: String,
    public val dnsName: String,
    public val dnsServers: List<String>,
    public val filters: List<GetEndpointFilter>? = null,
    public val id: String,
    public val securityGroupIds: List<String>,
    public val selfServicePortal: String,
    public val selfServicePortalUrl: String,
    public val serverCertificateArn: String,
    public val sessionTimeoutHours: Int,
    public val splitTunnel: Boolean,
    public val tags: Map<String, String>,
    public val transportProtocol: String,
    public val vpcId: String,
    public val vpnPort: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2clientvpn.outputs.GetEndpointResult): GetEndpointResult = GetEndpointResult(
            arn = javaType.arn(),
            authenticationOptions = javaType.authenticationOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2clientvpn.kotlin.outputs.GetEndpointAuthenticationOption.Companion.toKotlin(args0)
                })
            }),
            clientCidrBlock = javaType.clientCidrBlock(),
            clientConnectOptions = javaType.clientConnectOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2clientvpn.kotlin.outputs.GetEndpointClientConnectOption.Companion.toKotlin(args0)
                })
            }),
            clientLoginBannerOptions = javaType.clientLoginBannerOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2clientvpn.kotlin.outputs.GetEndpointClientLoginBannerOption.Companion.toKotlin(args0)
                })
            }),
            clientVpnEndpointId = javaType.clientVpnEndpointId(),
            connectionLogOptions = javaType.connectionLogOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2clientvpn.kotlin.outputs.GetEndpointConnectionLogOption.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description(),
            dnsName = javaType.dnsName(),
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2clientvpn.kotlin.outputs.GetEndpointFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            selfServicePortal = javaType.selfServicePortal(),
            selfServicePortalUrl = javaType.selfServicePortalUrl(),
            serverCertificateArn = javaType.serverCertificateArn(),
            sessionTimeoutHours = javaType.sessionTimeoutHours(),
            splitTunnel = javaType.splitTunnel(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transportProtocol = javaType.transportProtocol(),
            vpcId = javaType.vpcId(),
            vpnPort = javaType.vpnPort(),
        )
    }
}
