@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.ConnectPeerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway Connect Peer.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.Connect("example", {
 *     transportAttachmentId: exampleAwsEc2TransitGatewayVpcAttachment.id,
 *     transitGatewayId: exampleAwsEc2TransitGateway.id,
 * });
 * const exampleConnectPeer = new aws.ec2transitgateway.ConnectPeer("example", {
 *     peerAddress: "10.1.2.3",
 *     insideCidrBlocks: ["169&#46;254&#46;100&#46;0/29"],
 *     transitGatewayAttachmentId: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.Connect("example",
 *     transport_attachment_id=example_aws_ec2_transit_gateway_vpc_attachment["id"],
 *     transit_gateway_id=example_aws_ec2_transit_gateway["id"])
 * example_connect_peer = aws.ec2transitgateway.ConnectPeer("example",
 *     peer_address="10.1.2.3",
 *     inside_cidr_blocks=["169&#46;254&#46;100&#46;0/29"],
 *     transit_gateway_attachment_id=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.Connect("example", new()
 *     {
 *         TransportAttachmentId = exampleAwsEc2TransitGatewayVpcAttachment.Id,
 *         TransitGatewayId = exampleAwsEc2TransitGateway.Id,
 *     });
 *     var exampleConnectPeer = new Aws.Ec2TransitGateway.ConnectPeer("example", new()
 *     {
 *         PeerAddress = "10.1.2.3",
 *         InsideCidrBlocks = new[]
 *         {
 *             "169.254.100.0/29",
 *         },
 *         TransitGatewayAttachmentId = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2transitgateway.NewConnect(ctx, "example", &ec2transitgateway.ConnectArgs{
 * 			TransportAttachmentId: pulumi.Any(exampleAwsEc2TransitGatewayVpcAttachment.Id),
 * 			TransitGatewayId:      pulumi.Any(exampleAwsEc2TransitGateway.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2transitgateway.NewConnectPeer(ctx, "example", &ec2transitgateway.ConnectPeerArgs{
 * 			PeerAddress: pulumi.String("10.1.2.3"),
 * 			InsideCidrBlocks: pulumi.StringArray{
 * 				pulumi.String("169.254.100.0/29"),
 * 			},
 * 			TransitGatewayAttachmentId: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.Connect;
 * import com.pulumi.aws.ec2transitgateway.ConnectArgs;
 * import com.pulumi.aws.ec2transitgateway.ConnectPeer;
 * import com.pulumi.aws.ec2transitgateway.ConnectPeerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connect("example", ConnectArgs.builder()
 *             .transportAttachmentId(exampleAwsEc2TransitGatewayVpcAttachment.id())
 *             .transitGatewayId(exampleAwsEc2TransitGateway.id())
 *             .build());
 *         var exampleConnectPeer = new ConnectPeer("exampleConnectPeer", ConnectPeerArgs.builder()
 *             .peerAddress("10.1.2.3")
 *             .insideCidrBlocks("169.254.100.0/29")
 *             .transitGatewayAttachmentId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:Connect
 *     properties:
 *       transportAttachmentId: ${exampleAwsEc2TransitGatewayVpcAttachment.id}
 *       transitGatewayId: ${exampleAwsEc2TransitGateway.id}
 *   exampleConnectPeer:
 *     type: aws:ec2transitgateway:ConnectPeer
 *     name: example
 *     properties:
 *       peerAddress: 10.1.2.3
 *       insideCidrBlocks:
 *         - 169.254.100.0/29
 *       transitGatewayAttachmentId: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_connect_peer` using the EC2 Transit Gateway Connect Peer identifier. For example:
 * ```sh
 * $ pulumi import aws:ec2transitgateway/connectPeer:ConnectPeer example tgw-connect-peer-12345678
 * ```
 * @property bgpAsn The BGP ASN number assigned customer device. If not provided, it will use the same BGP ASN as is associated with Transit Gateway.
 * @property insideCidrBlocks The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
 * @property peerAddress The IP addressed assigned to customer device, which will be used as tunnel endpoint. It can be IPv4 or IPv6 address, but must be the same address family as `transit_gateway_address`
 * @property tags Key-value tags for the EC2 Transit Gateway Connect Peer. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayAddress The IP address assigned to Transit Gateway, which will be used as tunnel endpoint. This address must be from associated Transit Gateway CIDR block. The address must be from the same address family as `peer_address`. If not set explicitly, it will be selected from associated Transit Gateway CIDR blocks
 * @property transitGatewayAttachmentId The Transit Gateway Connect
 */
public data class ConnectPeerArgs(
    public val bgpAsn: Output<String>? = null,
    public val insideCidrBlocks: Output<List<String>>? = null,
    public val peerAddress: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayAddress: Output<String>? = null,
    public val transitGatewayAttachmentId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.ConnectPeerArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.ConnectPeerArgs =
        com.pulumi.aws.ec2transitgateway.ConnectPeerArgs.builder()
            .bgpAsn(bgpAsn?.applyValue({ args0 -> args0 }))
            .insideCidrBlocks(insideCidrBlocks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .peerAddress(peerAddress?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayAddress(transitGatewayAddress?.applyValue({ args0 -> args0 }))
            .transitGatewayAttachmentId(transitGatewayAttachmentId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectPeerArgs].
 */
@PulumiTagMarker
public class ConnectPeerArgsBuilder internal constructor() {
    private var bgpAsn: Output<String>? = null

    private var insideCidrBlocks: Output<List<String>>? = null

    private var peerAddress: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayAddress: Output<String>? = null

    private var transitGatewayAttachmentId: Output<String>? = null

    /**
     * @param value The BGP ASN number assigned customer device. If not provided, it will use the same BGP ASN as is associated with Transit Gateway.
     */
    @JvmName("faqkotmatdcrrefv")
    public suspend fun bgpAsn(`value`: Output<String>) {
        this.bgpAsn = value
    }

    /**
     * @param value The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
     */
    @JvmName("weudpruugofmqjnv")
    public suspend fun insideCidrBlocks(`value`: Output<List<String>>) {
        this.insideCidrBlocks = value
    }

    @JvmName("sunrdmpunyewsphr")
    public suspend fun insideCidrBlocks(vararg values: Output<String>) {
        this.insideCidrBlocks = Output.all(values.asList())
    }

    /**
     * @param values The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
     */
    @JvmName("mdpwnepdfptevgve")
    public suspend fun insideCidrBlocks(values: List<Output<String>>) {
        this.insideCidrBlocks = Output.all(values)
    }

    /**
     * @param value The IP addressed assigned to customer device, which will be used as tunnel endpoint. It can be IPv4 or IPv6 address, but must be the same address family as `transit_gateway_address`
     */
    @JvmName("pdseswfechgekksh")
    public suspend fun peerAddress(`value`: Output<String>) {
        this.peerAddress = value
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Connect Peer. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rgvyvjgujfyqxyuy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The IP address assigned to Transit Gateway, which will be used as tunnel endpoint. This address must be from associated Transit Gateway CIDR block. The address must be from the same address family as `peer_address`. If not set explicitly, it will be selected from associated Transit Gateway CIDR blocks
     */
    @JvmName("ihrmcbvpvwbxuxfl")
    public suspend fun transitGatewayAddress(`value`: Output<String>) {
        this.transitGatewayAddress = value
    }

    /**
     * @param value The Transit Gateway Connect
     */
    @JvmName("nexsvhvxcvgacmlb")
    public suspend fun transitGatewayAttachmentId(`value`: Output<String>) {
        this.transitGatewayAttachmentId = value
    }

    /**
     * @param value The BGP ASN number assigned customer device. If not provided, it will use the same BGP ASN as is associated with Transit Gateway.
     */
    @JvmName("qmpdhbpojvvxbcgl")
    public suspend fun bgpAsn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAsn = mapped
    }

    /**
     * @param value The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
     */
    @JvmName("bkwrtccgqeutgaig")
    public suspend fun insideCidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insideCidrBlocks = mapped
    }

    /**
     * @param values The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
     */
    @JvmName("kxfxhovlelpbtbug")
    public suspend fun insideCidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insideCidrBlocks = mapped
    }

    /**
     * @param value The IP addressed assigned to customer device, which will be used as tunnel endpoint. It can be IPv4 or IPv6 address, but must be the same address family as `transit_gateway_address`
     */
    @JvmName("qkgvyxcvwybyqsmy")
    public suspend fun peerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAddress = mapped
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Connect Peer. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ejexusljdbxlniuk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway Connect Peer. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kwlmbjayqngsbiiw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The IP address assigned to Transit Gateway, which will be used as tunnel endpoint. This address must be from associated Transit Gateway CIDR block. The address must be from the same address family as `peer_address`. If not set explicitly, it will be selected from associated Transit Gateway CIDR blocks
     */
    @JvmName("gwiygldhiopgntqs")
    public suspend fun transitGatewayAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAddress = mapped
    }

    /**
     * @param value The Transit Gateway Connect
     */
    @JvmName("xpmcyvgaqyinxvuh")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAttachmentId = mapped
    }

    internal fun build(): ConnectPeerArgs = ConnectPeerArgs(
        bgpAsn = bgpAsn,
        insideCidrBlocks = insideCidrBlocks,
        peerAddress = peerAddress,
        tags = tags,
        transitGatewayAddress = transitGatewayAddress,
        transitGatewayAttachmentId = transitGatewayAttachmentId,
    )
}
