@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getAttachmentPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getAttachmentsPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getConnectPeerPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getConnectPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getDirectConnectGatewayAttachmentPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getMulticastDomainPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getPeeringAttachmentPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getPeeringAttachmentsPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getRouteTableAssociationsPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getRouteTablePlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getRouteTablePropagationsPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getRouteTableRoutesPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getTransitGatewayPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getVpcAttachmentPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getVpcAttachmentsPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getVpnAttachmentPlain
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetAttachmentFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetAttachmentPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetAttachmentPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetAttachmentsFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetAttachmentsPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetAttachmentsPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetConnectFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetConnectPeerFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetConnectPeerPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetConnectPeerPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetConnectPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetConnectPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetDirectConnectGatewayAttachmentFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetDirectConnectGatewayAttachmentPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetDirectConnectGatewayAttachmentPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetMulticastDomainFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetMulticastDomainPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetMulticastDomainPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetPeeringAttachmentFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetPeeringAttachmentPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetPeeringAttachmentPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetPeeringAttachmentsFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetPeeringAttachmentsPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetPeeringAttachmentsPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTableAssociationsFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTableAssociationsPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTableAssociationsPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTableFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTablePlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTablePlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTablePropagationsFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTablePropagationsPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTablePropagationsPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTableRoutesFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTableRoutesPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTableRoutesPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetTransitGatewayFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetTransitGatewayPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetTransitGatewayPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpcAttachmentFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpcAttachmentPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpcAttachmentPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpcAttachmentsFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpcAttachmentsPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpcAttachmentsPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpnAttachmentFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpnAttachmentPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpnAttachmentPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetAttachmentResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetAttachmentsResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetConnectPeerResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetConnectResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetDirectConnectGatewayAttachmentResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetMulticastDomainResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetPeeringAttachmentResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetPeeringAttachmentsResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableAssociationsResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTablePropagationsResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableRoutesResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetTransitGatewayResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpcAttachmentResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpcAttachmentsResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpnAttachmentResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetAttachmentResult.Companion.toKotlin as getAttachmentResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetAttachmentsResult.Companion.toKotlin as getAttachmentsResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetConnectPeerResult.Companion.toKotlin as getConnectPeerResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetConnectResult.Companion.toKotlin as getConnectResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetDirectConnectGatewayAttachmentResult.Companion.toKotlin as getDirectConnectGatewayAttachmentResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetMulticastDomainResult.Companion.toKotlin as getMulticastDomainResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetPeeringAttachmentResult.Companion.toKotlin as getPeeringAttachmentResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetPeeringAttachmentsResult.Companion.toKotlin as getPeeringAttachmentsResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableAssociationsResult.Companion.toKotlin as getRouteTableAssociationsResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTablePropagationsResult.Companion.toKotlin as getRouteTablePropagationsResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableResult.Companion.toKotlin as getRouteTableResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableRoutesResult.Companion.toKotlin as getRouteTableRoutesResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetTransitGatewayResult.Companion.toKotlin as getTransitGatewayResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpcAttachmentResult.Companion.toKotlin as getVpcAttachmentResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpcAttachmentsResult.Companion.toKotlin as getVpcAttachmentsResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpnAttachmentResult.Companion.toKotlin as getVpnAttachmentResultToKotlin

public object Ec2transitgatewayFunctions {
    /**
     * Get information on an EC2 Transit Gateway's attachment to a resource.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getAttachment({
     *     filters: [
     *         {
     *             name: "transit-gateway-id",
     *             values: [exampleAwsEc2TransitGateway&#46;id],
     *         },
     *         {
     *             name: "resource-type",
     *             values: ["peering"],
     *         },
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_attachment(filters=[
     *     {
     *         "name": "transit-gateway-id",
     *         "values": [example_aws_ec2_transit_gateway["id"]],
     *     },
     *     {
     *         "name": "resource-type",
     *         "values": ["peering"],
     *     },
     * ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetAttachment.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2TransitGateway.Inputs.GetAttachmentFilterInputArgs
     *             {
     *                 Name = "transit-gateway-id",
     *                 Values = new[]
     *                 {
     *                     exampleAwsEc2TransitGateway.Id,
     *                 },
     *             },
     *             new Aws.Ec2TransitGateway.Inputs.GetAttachmentFilterInputArgs
     *             {
     *                 Name = "resource-type",
     *                 Values = new[]
     *                 {
     *                     "peering",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _, err := ec2transitgateway.GetAttachment(ctx, &ec2transitgateway.GetAttachmentArgs{
     * Filters: []ec2transitgateway.GetAttachmentFilter{
     * {
     * Name: "transit-gateway-id",
     * Values: interface{}{
     * exampleAwsEc2TransitGateway.Id,
     * },
     * },
     * {
     * Name: "resource-type",
     * Values: []string{
     * "peering",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getAttachment(GetAttachmentArgs.builder()
     *             .filters(
     *                 GetAttachmentFilterArgs.builder()
     *                     .name("transit-gateway-id")
     *                     .values(exampleAwsEc2TransitGateway.id())
     *                     .build(),
     *                 GetAttachmentFilterArgs.builder()
     *                     .name("resource-type")
     *                     .values("peering")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getAttachment
     *       Arguments:
     *         filters:
     *           - name: transit-gateway-id
     *             values:
     *               - ${exampleAwsEc2TransitGateway.id}
     *           - name: resource-type
     *             values:
     *               - peering
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAttachment.
     * @return A collection of values returned by getAttachment.
     */
    public suspend fun getAttachment(argument: GetAttachmentPlainArgs): GetAttachmentResult =
        getAttachmentResultToKotlin(getAttachmentPlain(argument.toJava()).await())

    /**
     * @see [getAttachment].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param tags Key-value tags for the attachment.
     * @param transitGatewayAttachmentId ID of the attachment.
     * @return A collection of values returned by getAttachment.
     */
    public suspend fun getAttachment(
        filters: List<GetAttachmentFilter>? = null,
        tags: Map<String, String>? = null,
        transitGatewayAttachmentId: String? = null,
    ): GetAttachmentResult {
        val argument = GetAttachmentPlainArgs(
            filters = filters,
            tags = tags,
            transitGatewayAttachmentId = transitGatewayAttachmentId,
        )
        return getAttachmentResultToKotlin(getAttachmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getAttachment].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetAttachmentPlainArgs].
     * @return A collection of values returned by getAttachment.
     */
    public suspend fun getAttachment(argument: suspend GetAttachmentPlainArgsBuilder.() -> Unit): GetAttachmentResult {
        val builder = GetAttachmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAttachmentResultToKotlin(getAttachmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on EC2 Transit Gateway Attachments.
     * ## Example Usage
     * ### By Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const filtered = aws.ec2transitgateway.getAttachments({
     *     filters: [
     *         {
     *             name: "state",
     *             values: ["pendingAcceptance"],
     *         },
     *         {
     *             name: "resource-type",
     *             values: ["vpc"],
     *         },
     *     ],
     * });
     * const unit = .map(__index => (aws.ec2transitgateway.getAttachment({
     *     transitGatewayAttachmentId: _arg0_.ids[__index],
     * })));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * filtered = aws.ec2transitgateway.get_attachments(filters=[
     *     {
     *         "name": "state",
     *         "values": ["pendingAcceptance"],
     *     },
     *     {
     *         "name": "resource-type",
     *         "values": ["vpc"],
     *     },
     * ])
     * unit = [aws&#46;ec2transitgateway&#46;get_attachment(transit_gateway_attachment_id=filtered&#46;ids[__index]) for __index in range(len(filtered&#46;ids))]
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var filtered = Aws.Ec2TransitGateway.GetAttachments.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2TransitGateway.Inputs.GetAttachmentsFilterInputArgs
     *             {
     *                 Name = "state",
     *                 Values = new[]
     *                 {
     *                     "pendingAcceptance",
     *                 },
     *             },
     *             new Aws.Ec2TransitGateway.Inputs.GetAttachmentsFilterInputArgs
     *             {
     *                 Name = "resource-type",
     *                 Values = new[]
     *                 {
     *                     "vpc",
     *                 },
     *             },
     *         },
     *     });
     *     var unit = ;
     * });
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAttachments.
     * @return A collection of values returned by getAttachments.
     */
    public suspend fun getAttachments(argument: GetAttachmentsPlainArgs): GetAttachmentsResult =
        getAttachmentsResultToKotlin(getAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getAttachments].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param tags
     * @return A collection of values returned by getAttachments.
     */
    public suspend fun getAttachments(
        filters: List<GetAttachmentsFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetAttachmentsResult {
        val argument = GetAttachmentsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getAttachmentsResultToKotlin(getAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetAttachmentsPlainArgs].
     * @return A collection of values returned by getAttachments.
     */
    public suspend fun getAttachments(argument: suspend GetAttachmentsPlainArgsBuilder.() -> Unit): GetAttachmentsResult {
        val builder = GetAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAttachmentsResultToKotlin(getAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway Connect.
     * ## Example Usage
     * ### By Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getConnect({
     *     filters: [{
     *         name: "transport-transit-gateway-attachment-id",
     *         values: ["tgw-attach-12345678"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_connect(filters=[{
     *     "name": "transport-transit-gateway-attachment-id",
     *     "values": ["tgw-attach-12345678"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetConnect.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2TransitGateway.Inputs.GetConnectFilterInputArgs
     *             {
     *                 Name = "transport-transit-gateway-attachment-id",
     *                 Values = new[]
     *                 {
     *                     "tgw-attach-12345678",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.LookupConnect(ctx, &ec2transitgateway.LookupConnectArgs{
     * 			Filters: []ec2transitgateway.GetConnectFilter{
     * 				{
     * 					Name: "transport-transit-gateway-attachment-id",
     * 					Values: []string{
     * 						"tgw-attach-12345678",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetConnectArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getConnect(GetConnectArgs.builder()
     *             .filters(GetConnectFilterArgs.builder()
     *                 .name("transport-transit-gateway-attachment-id")
     *                 .values("tgw-attach-12345678")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getConnect
     *       Arguments:
     *         filters:
     *           - name: transport-transit-gateway-attachment-id
     *             values:
     *               - tgw-attach-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * ### By Identifier
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getConnect({
     *     transitGatewayConnectId: "tgw-attach-12345678",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_connect(transit_gateway_connect_id="tgw-attach-12345678")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetConnect.Invoke(new()
     *     {
     *         TransitGatewayConnectId = "tgw-attach-12345678",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.LookupConnect(ctx, &ec2transitgateway.LookupConnectArgs{
     * 			TransitGatewayConnectId: pulumi.StringRef("tgw-attach-12345678"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetConnectArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getConnect(GetConnectArgs.builder()
     *             .transitGatewayConnectId("tgw-attach-12345678")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getConnect
     *       Arguments:
     *         transitGatewayConnectId: tgw-attach-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getConnect.
     * @return A collection of values returned by getConnect.
     */
    public suspend fun getConnect(argument: GetConnectPlainArgs): GetConnectResult =
        getConnectResultToKotlin(getConnectPlain(argument.toJava()).await())

    /**
     * @see [getConnect].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param tags Key-value tags for the EC2 Transit Gateway Connect
     * @param transitGatewayConnectId Identifier of the EC2 Transit Gateway Connect.
     * @return A collection of values returned by getConnect.
     */
    public suspend fun getConnect(
        filters: List<GetConnectFilter>? = null,
        tags: Map<String, String>? = null,
        transitGatewayConnectId: String? = null,
    ): GetConnectResult {
        val argument = GetConnectPlainArgs(
            filters = filters,
            tags = tags,
            transitGatewayConnectId = transitGatewayConnectId,
        )
        return getConnectResultToKotlin(getConnectPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnect].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetConnectPlainArgs].
     * @return A collection of values returned by getConnect.
     */
    public suspend fun getConnect(argument: suspend GetConnectPlainArgsBuilder.() -> Unit): GetConnectResult {
        val builder = GetConnectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectResultToKotlin(getConnectPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway Connect Peer.
     * ## Example Usage
     * ### By Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getConnectPeer({
     *     filters: [{
     *         name: "transit-gateway-attachment-id",
     *         values: ["tgw-attach-12345678"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_connect_peer(filters=[{
     *     "name": "transit-gateway-attachment-id",
     *     "values": ["tgw-attach-12345678"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetConnectPeer.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2TransitGateway.Inputs.GetConnectPeerFilterInputArgs
     *             {
     *                 Name = "transit-gateway-attachment-id",
     *                 Values = new[]
     *                 {
     *                     "tgw-attach-12345678",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.LookupConnectPeer(ctx, &ec2transitgateway.LookupConnectPeerArgs{
     * 			Filters: []ec2transitgateway.GetConnectPeerFilter{
     * 				{
     * 					Name: "transit-gateway-attachment-id",
     * 					Values: []string{
     * 						"tgw-attach-12345678",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetConnectPeerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getConnectPeer(GetConnectPeerArgs.builder()
     *             .filters(GetConnectPeerFilterArgs.builder()
     *                 .name("transit-gateway-attachment-id")
     *                 .values("tgw-attach-12345678")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getConnectPeer
     *       Arguments:
     *         filters:
     *           - name: transit-gateway-attachment-id
     *             values:
     *               - tgw-attach-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * ### By Identifier
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getConnectPeer({
     *     transitGatewayConnectPeerId: "tgw-connect-peer-12345678",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_connect_peer(transit_gateway_connect_peer_id="tgw-connect-peer-12345678")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetConnectPeer.Invoke(new()
     *     {
     *         TransitGatewayConnectPeerId = "tgw-connect-peer-12345678",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.LookupConnectPeer(ctx, &ec2transitgateway.LookupConnectPeerArgs{
     * 			TransitGatewayConnectPeerId: pulumi.StringRef("tgw-connect-peer-12345678"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetConnectPeerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getConnectPeer(GetConnectPeerArgs.builder()
     *             .transitGatewayConnectPeerId("tgw-connect-peer-12345678")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getConnectPeer
     *       Arguments:
     *         transitGatewayConnectPeerId: tgw-connect-peer-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getConnectPeer.
     * @return A collection of values returned by getConnectPeer.
     */
    public suspend fun getConnectPeer(argument: GetConnectPeerPlainArgs): GetConnectPeerResult =
        getConnectPeerResultToKotlin(getConnectPeerPlain(argument.toJava()).await())

    /**
     * @see [getConnectPeer].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param tags Key-value tags for the EC2 Transit Gateway Connect Peer
     * @param transitGatewayConnectPeerId Identifier of the EC2 Transit Gateway Connect Peer.
     * @return A collection of values returned by getConnectPeer.
     */
    public suspend fun getConnectPeer(
        filters: List<GetConnectPeerFilter>? = null,
        tags: Map<String, String>? = null,
        transitGatewayConnectPeerId: String? = null,
    ): GetConnectPeerResult {
        val argument = GetConnectPeerPlainArgs(
            filters = filters,
            tags = tags,
            transitGatewayConnectPeerId = transitGatewayConnectPeerId,
        )
        return getConnectPeerResultToKotlin(getConnectPeerPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnectPeer].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetConnectPeerPlainArgs].
     * @return A collection of values returned by getConnectPeer.
     */
    public suspend fun getConnectPeer(argument: suspend GetConnectPeerPlainArgsBuilder.() -> Unit): GetConnectPeerResult {
        val builder = GetConnectPeerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectPeerResultToKotlin(getConnectPeerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway's attachment to a Direct Connect Gateway.
     * ## Example Usage
     * ### By Transit Gateway and Direct Connect Gateway Identifiers
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getDirectConnectGatewayAttachment({
     *     transitGatewayId: exampleAwsEc2TransitGateway.id,
     *     dxGatewayId: exampleAwsDxGateway.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_direct_connect_gateway_attachment(transit_gateway_id=example_aws_ec2_transit_gateway["id"],
     *     dx_gateway_id=example_aws_dx_gateway["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetDirectConnectGatewayAttachment.Invoke(new()
     *     {
     *         TransitGatewayId = exampleAwsEc2TransitGateway.Id,
     *         DxGatewayId = exampleAwsDxGateway.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.GetDirectConnectGatewayAttachment(ctx, &ec2transitgateway.GetDirectConnectGatewayAttachmentArgs{
     * 			TransitGatewayId: pulumi.StringRef(exampleAwsEc2TransitGateway.Id),
     * 			DxGatewayId:      pulumi.StringRef(exampleAwsDxGateway.Id),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetDirectConnectGatewayAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getDirectConnectGatewayAttachment(GetDirectConnectGatewayAttachmentArgs.builder()
     *             .transitGatewayId(exampleAwsEc2TransitGateway.id())
     *             .dxGatewayId(exampleAwsDxGateway.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getDirectConnectGatewayAttachment
     *       Arguments:
     *         transitGatewayId: ${exampleAwsEc2TransitGateway.id}
     *         dxGatewayId: ${exampleAwsDxGateway.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDirectConnectGatewayAttachment.
     * @return A collection of values returned by getDirectConnectGatewayAttachment.
     */
    public suspend fun getDirectConnectGatewayAttachment(argument: GetDirectConnectGatewayAttachmentPlainArgs): GetDirectConnectGatewayAttachmentResult =
        getDirectConnectGatewayAttachmentResultToKotlin(getDirectConnectGatewayAttachmentPlain(argument.toJava()).await())

    /**
     * @see [getDirectConnectGatewayAttachment].
     * @param dxGatewayId Identifier of the Direct Connect Gateway.
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired Transit Gateway Direct Connect Gateway Attachment.
     * @param transitGatewayId Identifier of the EC2 Transit Gateway.
     * @return A collection of values returned by getDirectConnectGatewayAttachment.
     */
    public suspend fun getDirectConnectGatewayAttachment(
        dxGatewayId: String? = null,
        filters: List<GetDirectConnectGatewayAttachmentFilter>? = null,
        tags: Map<String, String>? = null,
        transitGatewayId: String? = null,
    ): GetDirectConnectGatewayAttachmentResult {
        val argument = GetDirectConnectGatewayAttachmentPlainArgs(
            dxGatewayId = dxGatewayId,
            filters = filters,
            tags = tags,
            transitGatewayId = transitGatewayId,
        )
        return getDirectConnectGatewayAttachmentResultToKotlin(getDirectConnectGatewayAttachmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getDirectConnectGatewayAttachment].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetDirectConnectGatewayAttachmentPlainArgs].
     * @return A collection of values returned by getDirectConnectGatewayAttachment.
     */
    public suspend fun getDirectConnectGatewayAttachment(argument: suspend GetDirectConnectGatewayAttachmentPlainArgsBuilder.() -> Unit): GetDirectConnectGatewayAttachmentResult {
        val builder = GetDirectConnectGatewayAttachmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDirectConnectGatewayAttachmentResultToKotlin(getDirectConnectGatewayAttachmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway Multicast Domain.
     * ## Example Usage
     * ### By Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getMulticastDomain({
     *     filters: [{
     *         name: "transit-gateway-multicast-domain-id",
     *         values: ["tgw-mcast-domain-12345678"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_multicast_domain(filters=[{
     *     "name": "transit-gateway-multicast-domain-id",
     *     "values": ["tgw-mcast-domain-12345678"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetMulticastDomain.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2TransitGateway.Inputs.GetMulticastDomainFilterInputArgs
     *             {
     *                 Name = "transit-gateway-multicast-domain-id",
     *                 Values = new[]
     *                 {
     *                     "tgw-mcast-domain-12345678",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.LookupMulticastDomain(ctx, &ec2transitgateway.LookupMulticastDomainArgs{
     * 			Filters: []ec2transitgateway.GetMulticastDomainFilter{
     * 				{
     * 					Name: "transit-gateway-multicast-domain-id",
     * 					Values: []string{
     * 						"tgw-mcast-domain-12345678",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetMulticastDomainArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getMulticastDomain(GetMulticastDomainArgs.builder()
     *             .filters(GetMulticastDomainFilterArgs.builder()
     *                 .name("transit-gateway-multicast-domain-id")
     *                 .values("tgw-mcast-domain-12345678")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getMulticastDomain
     *       Arguments:
     *         filters:
     *           - name: transit-gateway-multicast-domain-id
     *             values:
     *               - tgw-mcast-domain-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * ### By Identifier
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getMulticastDomain({
     *     transitGatewayMulticastDomainId: "tgw-mcast-domain-12345678",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_multicast_domain(transit_gateway_multicast_domain_id="tgw-mcast-domain-12345678")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetMulticastDomain.Invoke(new()
     *     {
     *         TransitGatewayMulticastDomainId = "tgw-mcast-domain-12345678",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.LookupMulticastDomain(ctx, &ec2transitgateway.LookupMulticastDomainArgs{
     * 			TransitGatewayMulticastDomainId: pulumi.StringRef("tgw-mcast-domain-12345678"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetMulticastDomainArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getMulticastDomain(GetMulticastDomainArgs.builder()
     *             .transitGatewayMulticastDomainId("tgw-mcast-domain-12345678")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getMulticastDomain
     *       Arguments:
     *         transitGatewayMulticastDomainId: tgw-mcast-domain-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMulticastDomain.
     * @return A collection of values returned by getMulticastDomain.
     */
    public suspend fun getMulticastDomain(argument: GetMulticastDomainPlainArgs): GetMulticastDomainResult =
        getMulticastDomainResultToKotlin(getMulticastDomainPlain(argument.toJava()).await())

    /**
     * @see [getMulticastDomain].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param tags Key-value tags for the EC2 Transit Gateway Multicast Domain.
     * @param transitGatewayMulticastDomainId Identifier of the EC2 Transit Gateway Multicast Domain.
     * @return A collection of values returned by getMulticastDomain.
     */
    public suspend fun getMulticastDomain(
        filters: List<GetMulticastDomainFilter>? = null,
        tags: Map<String, String>? = null,
        transitGatewayMulticastDomainId: String? = null,
    ): GetMulticastDomainResult {
        val argument = GetMulticastDomainPlainArgs(
            filters = filters,
            tags = tags,
            transitGatewayMulticastDomainId = transitGatewayMulticastDomainId,
        )
        return getMulticastDomainResultToKotlin(getMulticastDomainPlain(argument.toJava()).await())
    }

    /**
     * @see [getMulticastDomain].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetMulticastDomainPlainArgs].
     * @return A collection of values returned by getMulticastDomain.
     */
    public suspend fun getMulticastDomain(argument: suspend GetMulticastDomainPlainArgsBuilder.() -> Unit): GetMulticastDomainResult {
        val builder = GetMulticastDomainPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMulticastDomainResultToKotlin(getMulticastDomainPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway Peering Attachment.
     * ## Example Usage
     * ### By Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getPeeringAttachment({
     *     filters: [{
     *         name: "transit-gateway-attachment-id",
     *         values: ["tgw-attach-12345678"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_peering_attachment(filters=[{
     *     "name": "transit-gateway-attachment-id",
     *     "values": ["tgw-attach-12345678"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetPeeringAttachment.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2TransitGateway.Inputs.GetPeeringAttachmentFilterInputArgs
     *             {
     *                 Name = "transit-gateway-attachment-id",
     *                 Values = new[]
     *                 {
     *                     "tgw-attach-12345678",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.LookupPeeringAttachment(ctx, &ec2transitgateway.LookupPeeringAttachmentArgs{
     * 			Filters: []ec2transitgateway.GetPeeringAttachmentFilter{
     * 				{
     * 					Name: "transit-gateway-attachment-id",
     * 					Values: []string{
     * 						"tgw-attach-12345678",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetPeeringAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getPeeringAttachment(GetPeeringAttachmentArgs.builder()
     *             .filters(GetPeeringAttachmentFilterArgs.builder()
     *                 .name("transit-gateway-attachment-id")
     *                 .values("tgw-attach-12345678")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getPeeringAttachment
     *       Arguments:
     *         filters:
     *           - name: transit-gateway-attachment-id
     *             values:
     *               - tgw-attach-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * ### By Identifier
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const attachment = aws.ec2transitgateway.getPeeringAttachment({
     *     id: "tgw-attach-12345678",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * attachment = aws.ec2transitgateway.get_peering_attachment(id="tgw-attach-12345678")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var attachment = Aws.Ec2TransitGateway.GetPeeringAttachment.Invoke(new()
     *     {
     *         Id = "tgw-attach-12345678",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.LookupPeeringAttachment(ctx, &ec2transitgateway.LookupPeeringAttachmentArgs{
     * 			Id: pulumi.StringRef("tgw-attach-12345678"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetPeeringAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var attachment = Ec2transitgatewayFunctions.getPeeringAttachment(GetPeeringAttachmentArgs.builder()
     *             .id("tgw-attach-12345678")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   attachment:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getPeeringAttachment
     *       Arguments:
     *         id: tgw-attach-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPeeringAttachment.
     * @return A collection of values returned by getPeeringAttachment.
     */
    public suspend fun getPeeringAttachment(argument: GetPeeringAttachmentPlainArgs): GetPeeringAttachmentResult =
        getPeeringAttachmentResultToKotlin(getPeeringAttachmentPlain(argument.toJava()).await())

    /**
     * @see [getPeeringAttachment].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param id Identifier of the EC2 Transit Gateway Peering Attachment.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the specific EC2 Transit Gateway Peering Attachment to retrieve.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getPeeringAttachment.
     */
    public suspend fun getPeeringAttachment(
        filters: List<GetPeeringAttachmentFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetPeeringAttachmentResult {
        val argument = GetPeeringAttachmentPlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getPeeringAttachmentResultToKotlin(getPeeringAttachmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getPeeringAttachment].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetPeeringAttachmentPlainArgs].
     * @return A collection of values returned by getPeeringAttachment.
     */
    public suspend fun getPeeringAttachment(argument: suspend GetPeeringAttachmentPlainArgsBuilder.() -> Unit): GetPeeringAttachmentResult {
        val builder = GetPeeringAttachmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPeeringAttachmentResultToKotlin(getPeeringAttachmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on EC2 Transit Gateway Peering Attachments.
     * ## Example Usage
     * ### All Resources
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2transitgateway.getPeeringAttachments({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2transitgateway.get_peering_attachments()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2TransitGateway.GetPeeringAttachments.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.GetPeeringAttachments(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetPeeringAttachmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2transitgatewayFunctions.getPeeringAttachments();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getPeeringAttachments
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### By Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const filtered = aws.ec2transitgateway.getPeeringAttachments({
     *     filters: [{
     *         name: "state",
     *         values: ["pendingAcceptance"],
     *     }],
     * });
     * const unit = .map(__index => (aws.ec2transitgateway.getPeeringAttachment({
     *     id: _arg0_.ids[__index],
     * })));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * filtered = aws.ec2transitgateway.get_peering_attachments(filters=[{
     *     "name": "state",
     *     "values": ["pendingAcceptance"],
     * }])
     * unit = [aws&#46;ec2transitgateway&#46;get_peering_attachment(id=filtered&#46;ids[__index]) for __index in range(len(filtered&#46;ids))]
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var filtered = Aws.Ec2TransitGateway.GetPeeringAttachments.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2TransitGateway.Inputs.GetPeeringAttachmentsFilterInputArgs
     *             {
     *                 Name = "state",
     *                 Values = new[]
     *                 {
     *                     "pendingAcceptance",
     *                 },
     *             },
     *         },
     *     });
     *     var unit = ;
     * });
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPeeringAttachments.
     * @return A collection of values returned by getPeeringAttachments.
     */
    public suspend fun getPeeringAttachments(argument: GetPeeringAttachmentsPlainArgs): GetPeeringAttachmentsResult =
        getPeeringAttachmentsResultToKotlin(getPeeringAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getPeeringAttachments].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @return A collection of values returned by getPeeringAttachments.
     */
    public suspend fun getPeeringAttachments(filters: List<GetPeeringAttachmentsFilter>? = null): GetPeeringAttachmentsResult {
        val argument = GetPeeringAttachmentsPlainArgs(
            filters = filters,
        )
        return getPeeringAttachmentsResultToKotlin(getPeeringAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPeeringAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetPeeringAttachmentsPlainArgs].
     * @return A collection of values returned by getPeeringAttachments.
     */
    public suspend fun getPeeringAttachments(argument: suspend GetPeeringAttachmentsPlainArgsBuilder.() -> Unit): GetPeeringAttachmentsResult {
        val builder = GetPeeringAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPeeringAttachmentsResultToKotlin(getPeeringAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway Route Table.
     * ## Example Usage
     * ### By Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getRouteTable({
     *     filters: [
     *         {
     *             name: "default-association-route-table",
     *             values: ["true"],
     *         },
     *         {
     *             name: "transit-gateway-id",
     *             values: ["tgw-12345678"],
     *         },
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_route_table(filters=[
     *     {
     *         "name": "default-association-route-table",
     *         "values": ["true"],
     *     },
     *     {
     *         "name": "transit-gateway-id",
     *         "values": ["tgw-12345678"],
     *     },
     * ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetRouteTable.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2TransitGateway.Inputs.GetRouteTableFilterInputArgs
     *             {
     *                 Name = "default-association-route-table",
     *                 Values = new[]
     *                 {
     *                     "true",
     *                 },
     *             },
     *             new Aws.Ec2TransitGateway.Inputs.GetRouteTableFilterInputArgs
     *             {
     *                 Name = "transit-gateway-id",
     *                 Values = new[]
     *                 {
     *                     "tgw-12345678",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.LookupRouteTable(ctx, &ec2transitgateway.LookupRouteTableArgs{
     * 			Filters: []ec2transitgateway.GetRouteTableFilter{
     * 				{
     * 					Name: "default-association-route-table",
     * 					Values: []string{
     * 						"true",
     * 					},
     * 				},
     * 				{
     * 					Name: "transit-gateway-id",
     * 					Values: []string{
     * 						"tgw-12345678",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getRouteTable(GetRouteTableArgs.builder()
     *             .filters(
     *                 GetRouteTableFilterArgs.builder()
     *                     .name("default-association-route-table")
     *                     .values("true")
     *                     .build(),
     *                 GetRouteTableFilterArgs.builder()
     *                     .name("transit-gateway-id")
     *                     .values("tgw-12345678")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getRouteTable
     *       Arguments:
     *         filters:
     *           - name: default-association-route-table
     *             values:
     *               - 'true'
     *           - name: transit-gateway-id
     *             values:
     *               - tgw-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * ### By Identifier
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getRouteTable({
     *     id: "tgw-rtb-12345678",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_route_table(id="tgw-rtb-12345678")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetRouteTable.Invoke(new()
     *     {
     *         Id = "tgw-rtb-12345678",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.LookupRouteTable(ctx, &ec2transitgateway.LookupRouteTableArgs{
     * 			Id: pulumi.StringRef("tgw-rtb-12345678"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getRouteTable(GetRouteTableArgs.builder()
     *             .id("tgw-rtb-12345678")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getRouteTable
     *       Arguments:
     *         id: tgw-rtb-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRouteTable.
     * @return A collection of values returned by getRouteTable.
     */
    public suspend fun getRouteTable(argument: GetRouteTablePlainArgs): GetRouteTableResult =
        getRouteTableResultToKotlin(getRouteTablePlain(argument.toJava()).await())

    /**
     * @see [getRouteTable].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param id Identifier of the EC2 Transit Gateway Route Table.
     * @param tags Key-value tags for the EC2 Transit Gateway Route Table
     * @return A collection of values returned by getRouteTable.
     */
    public suspend fun getRouteTable(
        filters: List<GetRouteTableFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetRouteTableResult {
        val argument = GetRouteTablePlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getRouteTableResultToKotlin(getRouteTablePlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteTable].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetRouteTablePlainArgs].
     * @return A collection of values returned by getRouteTable.
     */
    public suspend fun getRouteTable(argument: suspend GetRouteTablePlainArgsBuilder.() -> Unit): GetRouteTableResult {
        val builder = GetRouteTablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteTableResultToKotlin(getRouteTablePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information for multiple EC2 Transit Gateway Route Table Associations, such as their identifiers.
     * ## Example Usage
     * ### By Transit Gateway Identifier
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getRouteTableAssociations({
     *     transitGatewayRouteTableId: exampleAwsEc2TransitGatewayRouteTable.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_route_table_associations(transit_gateway_route_table_id=example_aws_ec2_transit_gateway_route_table["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetRouteTableAssociations.Invoke(new()
     *     {
     *         TransitGatewayRouteTableId = exampleAwsEc2TransitGatewayRouteTable.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.GetRouteTableAssociations(ctx, &ec2transitgateway.GetRouteTableAssociationsArgs{
     * 			TransitGatewayRouteTableId: exampleAwsEc2TransitGatewayRouteTable.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableAssociationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getRouteTableAssociations(GetRouteTableAssociationsArgs.builder()
     *             .transitGatewayRouteTableId(exampleAwsEc2TransitGatewayRouteTable.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getRouteTableAssociations
     *       Arguments:
     *         transitGatewayRouteTableId: ${exampleAwsEc2TransitGatewayRouteTable.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRouteTableAssociations.
     * @return A collection of values returned by getRouteTableAssociations.
     */
    public suspend fun getRouteTableAssociations(argument: GetRouteTableAssociationsPlainArgs): GetRouteTableAssociationsResult =
        getRouteTableAssociationsResultToKotlin(getRouteTableAssociationsPlain(argument.toJava()).await())

    /**
     * @see [getRouteTableAssociations].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param transitGatewayRouteTableId Identifier of EC2 Transit Gateway Route Table.
     * The following arguments are optional:
     * @return A collection of values returned by getRouteTableAssociations.
     */
    public suspend fun getRouteTableAssociations(
        filters: List<GetRouteTableAssociationsFilter>? =
            null,
        transitGatewayRouteTableId: String,
    ): GetRouteTableAssociationsResult {
        val argument = GetRouteTableAssociationsPlainArgs(
            filters = filters,
            transitGatewayRouteTableId = transitGatewayRouteTableId,
        )
        return getRouteTableAssociationsResultToKotlin(getRouteTableAssociationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteTableAssociations].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetRouteTableAssociationsPlainArgs].
     * @return A collection of values returned by getRouteTableAssociations.
     */
    public suspend fun getRouteTableAssociations(argument: suspend GetRouteTableAssociationsPlainArgsBuilder.() -> Unit): GetRouteTableAssociationsResult {
        val builder = GetRouteTableAssociationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteTableAssociationsResultToKotlin(getRouteTableAssociationsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information for multiple EC2 Transit Gateway Route Table Propagations, such as their identifiers.
     * ## Example Usage
     * ### By Transit Gateway Identifier
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getRouteTablePropagations({
     *     transitGatewayRouteTableId: exampleAwsEc2TransitGatewayRouteTable.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_route_table_propagations(transit_gateway_route_table_id=example_aws_ec2_transit_gateway_route_table["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetRouteTablePropagations.Invoke(new()
     *     {
     *         TransitGatewayRouteTableId = exampleAwsEc2TransitGatewayRouteTable.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.GetRouteTablePropagations(ctx, &ec2transitgateway.GetRouteTablePropagationsArgs{
     * 			TransitGatewayRouteTableId: exampleAwsEc2TransitGatewayRouteTable.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetRouteTablePropagationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getRouteTablePropagations(GetRouteTablePropagationsArgs.builder()
     *             .transitGatewayRouteTableId(exampleAwsEc2TransitGatewayRouteTable.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getRouteTablePropagations
     *       Arguments:
     *         transitGatewayRouteTableId: ${exampleAwsEc2TransitGatewayRouteTable.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRouteTablePropagations.
     * @return A collection of values returned by getRouteTablePropagations.
     */
    public suspend fun getRouteTablePropagations(argument: GetRouteTablePropagationsPlainArgs): GetRouteTablePropagationsResult =
        getRouteTablePropagationsResultToKotlin(getRouteTablePropagationsPlain(argument.toJava()).await())

    /**
     * @see [getRouteTablePropagations].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param transitGatewayRouteTableId Identifier of EC2 Transit Gateway Route Table.
     * The following arguments are optional:
     * @return A collection of values returned by getRouteTablePropagations.
     */
    public suspend fun getRouteTablePropagations(
        filters: List<GetRouteTablePropagationsFilter>? =
            null,
        transitGatewayRouteTableId: String,
    ): GetRouteTablePropagationsResult {
        val argument = GetRouteTablePropagationsPlainArgs(
            filters = filters,
            transitGatewayRouteTableId = transitGatewayRouteTableId,
        )
        return getRouteTablePropagationsResultToKotlin(getRouteTablePropagationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteTablePropagations].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetRouteTablePropagationsPlainArgs].
     * @return A collection of values returned by getRouteTablePropagations.
     */
    public suspend fun getRouteTablePropagations(argument: suspend GetRouteTablePropagationsPlainArgsBuilder.() -> Unit): GetRouteTablePropagationsResult {
        val builder = GetRouteTablePropagationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteTablePropagationsResultToKotlin(getRouteTablePropagationsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides informations for routes of a specific transit gateway, such as state, type, cidr
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2transitgateway.getRouteTableRoutes({
     *     filters: [{
     *         name: "type",
     *         values: ["propagated"],
     *     }],
     *     transitGatewayRouteTableId: example.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2transitgateway.get_route_table_routes(filters=[{
     *         "name": "type",
     *         "values": ["propagated"],
     *     }],
     *     transit_gateway_route_table_id=example["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2TransitGateway.GetRouteTableRoutes.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2TransitGateway.Inputs.GetRouteTableRoutesFilterInputArgs
     *             {
     *                 Name = "type",
     *                 Values = new[]
     *                 {
     *                     "propagated",
     *                 },
     *             },
     *         },
     *         TransitGatewayRouteTableId = example.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.GetRouteTableRoutes(ctx, &ec2transitgateway.GetRouteTableRoutesArgs{
     * 			Filters: []ec2transitgateway.GetRouteTableRoutesFilter{
     * 				{
     * 					Name: "type",
     * 					Values: []string{
     * 						"propagated",
     * 					},
     * 				},
     * 			},
     * 			TransitGatewayRouteTableId: example.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableRoutesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2transitgatewayFunctions.getRouteTableRoutes(GetRouteTableRoutesArgs.builder()
     *             .filters(GetRouteTableRoutesFilterArgs.builder()
     *                 .name("type")
     *                 .values("propagated")
     *                 .build())
     *             .transitGatewayRouteTableId(example.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getRouteTableRoutes
     *       Arguments:
     *         filters:
     *           - name: type
     *             values:
     *               - propagated
     *         transitGatewayRouteTableId: ${example.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRouteTableRoutes.
     * @return A collection of values returned by getRouteTableRoutes.
     */
    public suspend fun getRouteTableRoutes(argument: GetRouteTableRoutesPlainArgs): GetRouteTableRoutesResult =
        getRouteTableRoutesResultToKotlin(getRouteTableRoutesPlain(argument.toJava()).await())

    /**
     * @see [getRouteTableRoutes].
     * @param filters Custom filter block as described below.
     * @param transitGatewayRouteTableId Identifier of EC2 Transit Gateway Route Table.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getRouteTableRoutes.
     */
    public suspend fun getRouteTableRoutes(
        filters: List<GetRouteTableRoutesFilter>,
        transitGatewayRouteTableId: String,
    ): GetRouteTableRoutesResult {
        val argument = GetRouteTableRoutesPlainArgs(
            filters = filters,
            transitGatewayRouteTableId = transitGatewayRouteTableId,
        )
        return getRouteTableRoutesResultToKotlin(getRouteTableRoutesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteTableRoutes].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetRouteTableRoutesPlainArgs].
     * @return A collection of values returned by getRouteTableRoutes.
     */
    public suspend fun getRouteTableRoutes(argument: suspend GetRouteTableRoutesPlainArgsBuilder.() -> Unit): GetRouteTableRoutesResult {
        val builder = GetRouteTableRoutesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteTableRoutesResultToKotlin(getRouteTableRoutesPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway.
     * ## Example Usage
     * ### By Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getTransitGateway({
     *     filters: [{
     *         name: "options.amazon-side-asn",
     *         values: ["64512"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_transit_gateway(filters=[{
     *     "name": "options.amazon-side-asn",
     *     "values": ["64512"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetTransitGateway.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2TransitGateway.Inputs.GetTransitGatewayFilterInputArgs
     *             {
     *                 Name = "options.amazon-side-asn",
     *                 Values = new[]
     *                 {
     *                     "64512",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.LookupTransitGateway(ctx, &ec2transitgateway.LookupTransitGatewayArgs{
     * 			Filters: []ec2transitgateway.GetTransitGatewayFilter{
     * 				{
     * 					Name: "options.amazon-side-asn",
     * 					Values: []string{
     * 						"64512",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetTransitGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getTransitGateway(GetTransitGatewayArgs.builder()
     *             .filters(GetTransitGatewayFilterArgs.builder()
     *                 .name("options.amazon-side-asn")
     *                 .values("64512")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getTransitGateway
     *       Arguments:
     *         filters:
     *           - name: options.amazon-side-asn
     *             values:
     *               - '64512'
     * ```
     * <!--End PulumiCodeChooser -->
     * ### By Identifier
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getTransitGateway({
     *     id: "tgw-12345678",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_transit_gateway(id="tgw-12345678")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetTransitGateway.Invoke(new()
     *     {
     *         Id = "tgw-12345678",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.LookupTransitGateway(ctx, &ec2transitgateway.LookupTransitGatewayArgs{
     * 			Id: pulumi.StringRef("tgw-12345678"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetTransitGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getTransitGateway(GetTransitGatewayArgs.builder()
     *             .id("tgw-12345678")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getTransitGateway
     *       Arguments:
     *         id: tgw-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitGateway.
     * @return A collection of values returned by getTransitGateway.
     */
    public suspend fun getTransitGateway(argument: GetTransitGatewayPlainArgs): GetTransitGatewayResult =
        getTransitGatewayResultToKotlin(getTransitGatewayPlain(argument.toJava()).await())

    /**
     * @see [getTransitGateway].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param id Identifier of the EC2 Transit Gateway.
     * @param tags Key-value tags for the EC2 Transit Gateway
     * @return A collection of values returned by getTransitGateway.
     */
    public suspend fun getTransitGateway(
        filters: List<GetTransitGatewayFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetTransitGatewayResult {
        val argument = GetTransitGatewayPlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getTransitGatewayResultToKotlin(getTransitGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetTransitGatewayPlainArgs].
     * @return A collection of values returned by getTransitGateway.
     */
    public suspend fun getTransitGateway(argument: suspend GetTransitGatewayPlainArgsBuilder.() -> Unit): GetTransitGatewayResult {
        val builder = GetTransitGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitGatewayResultToKotlin(getTransitGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway VPC Attachment.
     * ## Example Usage
     * ### By Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getVpcAttachment({
     *     filters: [{
     *         name: "vpc-id",
     *         values: ["vpc-12345678"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_vpc_attachment(filters=[{
     *     "name": "vpc-id",
     *     "values": ["vpc-12345678"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetVpcAttachment.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2TransitGateway.Inputs.GetVpcAttachmentFilterInputArgs
     *             {
     *                 Name = "vpc-id",
     *                 Values = new[]
     *                 {
     *                     "vpc-12345678",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.LookupVpcAttachment(ctx, &ec2transitgateway.LookupVpcAttachmentArgs{
     * 			Filters: []ec2transitgateway.GetVpcAttachmentFilter{
     * 				{
     * 					Name: "vpc-id",
     * 					Values: []string{
     * 						"vpc-12345678",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetVpcAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getVpcAttachment(GetVpcAttachmentArgs.builder()
     *             .filters(GetVpcAttachmentFilterArgs.builder()
     *                 .name("vpc-id")
     *                 .values("vpc-12345678")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getVpcAttachment
     *       Arguments:
     *         filters:
     *           - name: vpc-id
     *             values:
     *               - vpc-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * ### By Identifier
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getVpcAttachment({
     *     id: "tgw-attach-12345678",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_vpc_attachment(id="tgw-attach-12345678")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetVpcAttachment.Invoke(new()
     *     {
     *         Id = "tgw-attach-12345678",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.LookupVpcAttachment(ctx, &ec2transitgateway.LookupVpcAttachmentArgs{
     * 			Id: pulumi.StringRef("tgw-attach-12345678"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetVpcAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getVpcAttachment(GetVpcAttachmentArgs.builder()
     *             .id("tgw-attach-12345678")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getVpcAttachment
     *       Arguments:
     *         id: tgw-attach-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcAttachment.
     * @return A collection of values returned by getVpcAttachment.
     */
    public suspend fun getVpcAttachment(argument: GetVpcAttachmentPlainArgs): GetVpcAttachmentResult =
        getVpcAttachmentResultToKotlin(getVpcAttachmentPlain(argument.toJava()).await())

    /**
     * @see [getVpcAttachment].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param id Identifier of the EC2 Transit Gateway VPC Attachment.
     * @param tags Key-value tags for the EC2 Transit Gateway VPC Attachment
     * @return A collection of values returned by getVpcAttachment.
     */
    public suspend fun getVpcAttachment(
        filters: List<GetVpcAttachmentFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetVpcAttachmentResult {
        val argument = GetVpcAttachmentPlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getVpcAttachmentResultToKotlin(getVpcAttachmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcAttachment].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetVpcAttachmentPlainArgs].
     * @return A collection of values returned by getVpcAttachment.
     */
    public suspend fun getVpcAttachment(argument: suspend GetVpcAttachmentPlainArgsBuilder.() -> Unit): GetVpcAttachmentResult {
        val builder = GetVpcAttachmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcAttachmentResultToKotlin(getVpcAttachmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on EC2 Transit Gateway VPC Attachments.
     * ## Example Usage
     * ### By Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const filtered = aws.ec2transitgateway.getVpcAttachments({
     *     filters: [{
     *         name: "state",
     *         values: ["pendingAcceptance"],
     *     }],
     * });
     * const unit = .map(__index => (aws.ec2transitgateway.getVpcAttachment({
     *     id: _arg0_.ids[__index],
     * })));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * filtered = aws.ec2transitgateway.get_vpc_attachments(filters=[{
     *     "name": "state",
     *     "values": ["pendingAcceptance"],
     * }])
     * unit = [aws&#46;ec2transitgateway&#46;get_vpc_attachment(id=filtered&#46;ids[__index]) for __index in range(len(filtered&#46;ids))]
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var filtered = Aws.Ec2TransitGateway.GetVpcAttachments.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2TransitGateway.Inputs.GetVpcAttachmentsFilterInputArgs
     *             {
     *                 Name = "state",
     *                 Values = new[]
     *                 {
     *                     "pendingAcceptance",
     *                 },
     *             },
     *         },
     *     });
     *     var unit = ;
     * });
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcAttachments.
     * @return A collection of values returned by getVpcAttachments.
     */
    public suspend fun getVpcAttachments(argument: GetVpcAttachmentsPlainArgs): GetVpcAttachmentsResult =
        getVpcAttachmentsResultToKotlin(getVpcAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getVpcAttachments].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @return A collection of values returned by getVpcAttachments.
     */
    public suspend fun getVpcAttachments(filters: List<GetVpcAttachmentsFilter>? = null): GetVpcAttachmentsResult {
        val argument = GetVpcAttachmentsPlainArgs(
            filters = filters,
        )
        return getVpcAttachmentsResultToKotlin(getVpcAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetVpcAttachmentsPlainArgs].
     * @return A collection of values returned by getVpcAttachments.
     */
    public suspend fun getVpcAttachments(argument: suspend GetVpcAttachmentsPlainArgsBuilder.() -> Unit): GetVpcAttachmentsResult {
        val builder = GetVpcAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcAttachmentsResultToKotlin(getVpcAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway VPN Attachment.
     * > EC2 Transit Gateway VPN Attachments are implicitly created by VPN Connections referencing an EC2 Transit Gateway so there is no managed resource. For ease, the `aws.ec2.VpnConnection` resource includes a `transit_gateway_attachment_id` attribute which can replace some usage of this data source. For tagging the attachment, see the `aws.ec2.Tag` resource.
     * ## Example Usage
     * ### By Transit Gateway and VPN Connection Identifiers
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2transitgateway.getVpnAttachment({
     *     transitGatewayId: exampleAwsEc2TransitGateway.id,
     *     vpnConnectionId: exampleAwsVpnConnection.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2transitgateway.get_vpn_attachment(transit_gateway_id=example_aws_ec2_transit_gateway["id"],
     *     vpn_connection_id=example_aws_vpn_connection["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2TransitGateway.GetVpnAttachment.Invoke(new()
     *     {
     *         TransitGatewayId = exampleAwsEc2TransitGateway.Id,
     *         VpnConnectionId = exampleAwsVpnConnection.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.GetVpnAttachment(ctx, &ec2transitgateway.GetVpnAttachmentArgs{
     * 			TransitGatewayId: pulumi.StringRef(exampleAwsEc2TransitGateway.Id),
     * 			VpnConnectionId:  pulumi.StringRef(exampleAwsVpnConnection.Id),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetVpnAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getVpnAttachment(GetVpnAttachmentArgs.builder()
     *             .transitGatewayId(exampleAwsEc2TransitGateway.id())
     *             .vpnConnectionId(exampleAwsVpnConnection.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getVpnAttachment
     *       Arguments:
     *         transitGatewayId: ${exampleAwsEc2TransitGateway.id}
     *         vpnConnectionId: ${exampleAwsVpnConnection.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2transitgateway.getVpnAttachment({
     *     filters: [{
     *         name: "resource-id",
     *         values: ["some-resource"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2transitgateway.get_vpn_attachment(filters=[{
     *     "name": "resource-id",
     *     "values": ["some-resource"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2TransitGateway.GetVpnAttachment.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2TransitGateway.Inputs.GetVpnAttachmentFilterInputArgs
     *             {
     *                 Name = "resource-id",
     *                 Values = new[]
     *                 {
     *                     "some-resource",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2transitgateway.GetVpnAttachment(ctx, &ec2transitgateway.GetVpnAttachmentArgs{
     * 			Filters: []ec2transitgateway.GetVpnAttachmentFilter{
     * 				{
     * 					Name: "resource-id",
     * 					Values: []string{
     * 						"some-resource",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetVpnAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2transitgatewayFunctions.getVpnAttachment(GetVpnAttachmentArgs.builder()
     *             .filters(GetVpnAttachmentFilterArgs.builder()
     *                 .name("resource-id")
     *                 .values("some-resource")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2transitgateway:getVpnAttachment
     *       Arguments:
     *         filters:
     *           - name: resource-id
     *             values:
     *               - some-resource
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpnAttachment.
     * @return A collection of values returned by getVpnAttachment.
     */
    public suspend fun getVpnAttachment(argument: GetVpnAttachmentPlainArgs): GetVpnAttachmentResult =
        getVpnAttachmentResultToKotlin(getVpnAttachmentPlain(argument.toJava()).await())

    /**
     * @see [getVpnAttachment].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired Transit Gateway VPN Attachment.
     * @param transitGatewayId Identifier of the EC2 Transit Gateway.
     * @param vpnConnectionId Identifier of the EC2 VPN Connection.
     * @return A collection of values returned by getVpnAttachment.
     */
    public suspend fun getVpnAttachment(
        filters: List<GetVpnAttachmentFilter>? = null,
        tags: Map<String, String>? = null,
        transitGatewayId: String? = null,
        vpnConnectionId: String? = null,
    ): GetVpnAttachmentResult {
        val argument = GetVpnAttachmentPlainArgs(
            filters = filters,
            tags = tags,
            transitGatewayId = transitGatewayId,
            vpnConnectionId = vpnConnectionId,
        )
        return getVpnAttachmentResultToKotlin(getVpnAttachmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpnAttachment].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetVpnAttachmentPlainArgs].
     * @return A collection of values returned by getVpnAttachment.
     */
    public suspend fun getVpnAttachment(argument: suspend GetVpnAttachmentPlainArgsBuilder.() -> Unit): GetVpnAttachmentResult {
        val builder = GetVpnAttachmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpnAttachmentResultToKotlin(getVpnAttachmentPlain(builtArgument.toJava()).await())
    }
}
