@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.MulticastGroupMemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Registers members (network interfaces) with the transit gateway multicast group.
 * A member is a network interface associated with a supported EC2 instance that receives multicast traffic.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.MulticastGroupMember("example", {
 *     groupIpAddress: "224.0.0.1",
 *     networkInterfaceId: exampleAwsNetworkInterface.id,
 *     transitGatewayMulticastDomainId: exampleAwsEc2TransitGatewayMulticastDomain.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.MulticastGroupMember("example",
 *     group_ip_address="224.0.0.1",
 *     network_interface_id=example_aws_network_interface["id"],
 *     transit_gateway_multicast_domain_id=example_aws_ec2_transit_gateway_multicast_domain["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.MulticastGroupMember("example", new()
 *     {
 *         GroupIpAddress = "224.0.0.1",
 *         NetworkInterfaceId = exampleAwsNetworkInterface.Id,
 *         TransitGatewayMulticastDomainId = exampleAwsEc2TransitGatewayMulticastDomain.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2transitgateway.NewMulticastGroupMember(ctx, "example", &ec2transitgateway.MulticastGroupMemberArgs{
 * 			GroupIpAddress:                  pulumi.String("224.0.0.1"),
 * 			NetworkInterfaceId:              pulumi.Any(exampleAwsNetworkInterface.Id),
 * 			TransitGatewayMulticastDomainId: pulumi.Any(exampleAwsEc2TransitGatewayMulticastDomain.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupMember;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MulticastGroupMember("example", MulticastGroupMemberArgs.builder()
 *             .groupIpAddress("224.0.0.1")
 *             .networkInterfaceId(exampleAwsNetworkInterface.id())
 *             .transitGatewayMulticastDomainId(exampleAwsEc2TransitGatewayMulticastDomain.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:MulticastGroupMember
 *     properties:
 *       groupIpAddress: 224.0.0.1
 *       networkInterfaceId: ${exampleAwsNetworkInterface.id}
 *       transitGatewayMulticastDomainId: ${exampleAwsEc2TransitGatewayMulticastDomain.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property groupIpAddress The IP address assigned to the transit gateway multicast group.
 * @property networkInterfaceId The group members' network interface ID to register with the transit gateway multicast group.
 * @property transitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
 */
public data class MulticastGroupMemberArgs(
    public val groupIpAddress: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val transitGatewayMulticastDomainId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.MulticastGroupMemberArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.MulticastGroupMemberArgs =
        com.pulumi.aws.ec2transitgateway.MulticastGroupMemberArgs.builder()
            .groupIpAddress(groupIpAddress?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .transitGatewayMulticastDomainId(
                transitGatewayMulticastDomainId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [MulticastGroupMemberArgs].
 */
@PulumiTagMarker
public class MulticastGroupMemberArgsBuilder internal constructor() {
    private var groupIpAddress: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var transitGatewayMulticastDomainId: Output<String>? = null

    /**
     * @param value The IP address assigned to the transit gateway multicast group.
     */
    @JvmName("asxaixdxrnpyovnn")
    public suspend fun groupIpAddress(`value`: Output<String>) {
        this.groupIpAddress = value
    }

    /**
     * @param value The group members' network interface ID to register with the transit gateway multicast group.
     */
    @JvmName("gkahtimtcrxpyotj")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The ID of the transit gateway multicast domain.
     */
    @JvmName("kmjoechyomfjuoji")
    public suspend fun transitGatewayMulticastDomainId(`value`: Output<String>) {
        this.transitGatewayMulticastDomainId = value
    }

    /**
     * @param value The IP address assigned to the transit gateway multicast group.
     */
    @JvmName("mbcdpyxfrsusxgjk")
    public suspend fun groupIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIpAddress = mapped
    }

    /**
     * @param value The group members' network interface ID to register with the transit gateway multicast group.
     */
    @JvmName("fsmhxwmelateuchs")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The ID of the transit gateway multicast domain.
     */
    @JvmName("fiqohjqwtwlowyis")
    public suspend fun transitGatewayMulticastDomainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayMulticastDomainId = mapped
    }

    internal fun build(): MulticastGroupMemberArgs = MulticastGroupMemberArgs(
        groupIpAddress = groupIpAddress,
        networkInterfaceId = networkInterfaceId,
        transitGatewayMulticastDomainId = transitGatewayMulticastDomainId,
    )
}
