@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MulticastGroupSource].
 */
@PulumiTagMarker
public class MulticastGroupSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MulticastGroupSourceArgs = MulticastGroupSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MulticastGroupSourceArgsBuilder.() -> Unit) {
        val builder = MulticastGroupSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MulticastGroupSource {
        val builtJavaResource =
            com.pulumi.aws.ec2transitgateway.MulticastGroupSource(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MulticastGroupSource(builtJavaResource)
    }
}

/**
 * Registers sources (network interfaces) with the transit gateway multicast group.
 * A multicast source is a network interface attached to a supported instance that sends multicast traffic.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.MulticastGroupSource("example", {
 *     groupIpAddress: "224.0.0.1",
 *     networkInterfaceId: exampleAwsNetworkInterface.id,
 *     transitGatewayMulticastDomainId: exampleAwsEc2TransitGatewayMulticastDomain.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.MulticastGroupSource("example",
 *     group_ip_address="224.0.0.1",
 *     network_interface_id=example_aws_network_interface["id"],
 *     transit_gateway_multicast_domain_id=example_aws_ec2_transit_gateway_multicast_domain["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.MulticastGroupSource("example", new()
 *     {
 *         GroupIpAddress = "224.0.0.1",
 *         NetworkInterfaceId = exampleAwsNetworkInterface.Id,
 *         TransitGatewayMulticastDomainId = exampleAwsEc2TransitGatewayMulticastDomain.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2transitgateway.NewMulticastGroupSource(ctx, "example", &ec2transitgateway.MulticastGroupSourceArgs{
 * 			GroupIpAddress:                  pulumi.String("224.0.0.1"),
 * 			NetworkInterfaceId:              pulumi.Any(exampleAwsNetworkInterface.Id),
 * 			TransitGatewayMulticastDomainId: pulumi.Any(exampleAwsEc2TransitGatewayMulticastDomain.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupSource;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MulticastGroupSource("example", MulticastGroupSourceArgs.builder()
 *             .groupIpAddress("224.0.0.1")
 *             .networkInterfaceId(exampleAwsNetworkInterface.id())
 *             .transitGatewayMulticastDomainId(exampleAwsEc2TransitGatewayMulticastDomain.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:MulticastGroupSource
 *     properties:
 *       groupIpAddress: 224.0.0.1
 *       networkInterfaceId: ${exampleAwsNetworkInterface.id}
 *       transitGatewayMulticastDomainId: ${exampleAwsEc2TransitGatewayMulticastDomain.id}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class MulticastGroupSource internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.MulticastGroupSource,
) : KotlinCustomResource(javaResource, MulticastGroupSourceMapper) {
    /**
     * The IP address assigned to the transit gateway multicast group.
     */
    public val groupIpAddress: Output<String>
        get() = javaResource.groupIpAddress().applyValue({ args0 -> args0 })

    /**
     * The group members' network interface ID to register with the transit gateway multicast group.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The ID of the transit gateway multicast domain.
     */
    public val transitGatewayMulticastDomainId: Output<String>
        get() = javaResource.transitGatewayMulticastDomainId().applyValue({ args0 -> args0 })
}

public object MulticastGroupSourceMapper : ResourceMapper<MulticastGroupSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.MulticastGroupSource::class == javaResource::class

    override fun map(javaResource: Resource): MulticastGroupSource = MulticastGroupSource(
        javaResource
            as com.pulumi.aws.ec2transitgateway.MulticastGroupSource,
    )
}

/**
 * @see [MulticastGroupSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MulticastGroupSource].
 */
public suspend fun multicastGroupSource(
    name: String,
    block: suspend MulticastGroupSourceResourceBuilder.() -> Unit,
): MulticastGroupSource {
    val builder = MulticastGroupSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MulticastGroupSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun multicastGroupSource(name: String): MulticastGroupSource {
    val builder = MulticastGroupSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
