@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages the accepter's side of an EC2 Transit Gateway Peering Attachment.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.PeeringAttachmentAccepter("example", {
 *     transitGatewayAttachmentId: exampleAwsEc2TransitGatewayPeeringAttachment.id,
 *     tags: {
 *         Name: "Example cross-account attachment",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.PeeringAttachmentAccepter("example",
 *     transit_gateway_attachment_id=example_aws_ec2_transit_gateway_peering_attachment["id"],
 *     tags={
 *         "Name": "Example cross-account attachment",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.PeeringAttachmentAccepter("example", new()
 *     {
 *         TransitGatewayAttachmentId = exampleAwsEc2TransitGatewayPeeringAttachment.Id,
 *         Tags =
 *         {
 *             { "Name", "Example cross-account attachment" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2transitgateway.NewPeeringAttachmentAccepter(ctx, "example", &ec2transitgateway.PeeringAttachmentAccepterArgs{
 * 			TransitGatewayAttachmentId: pulumi.Any(exampleAwsEc2TransitGatewayPeeringAttachment.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example cross-account attachment"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepter;
 * import com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PeeringAttachmentAccepter("example", PeeringAttachmentAccepterArgs.builder()
 *             .transitGatewayAttachmentId(exampleAwsEc2TransitGatewayPeeringAttachment.id())
 *             .tags(Map.of("Name", "Example cross-account attachment"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:PeeringAttachmentAccepter
 *     properties:
 *       transitGatewayAttachmentId: ${exampleAwsEc2TransitGatewayPeeringAttachment.id}
 *       tags:
 *         Name: Example cross-account attachment
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_peering_attachment_accepter` using the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 * $ pulumi import aws:ec2transitgateway/peeringAttachmentAccepter:PeeringAttachmentAccepter example tgw-attach-12345678
 * ```
 * @property tags Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayAttachmentId The ID of the EC2 Transit Gateway Peering Attachment to manage.
 */
public data class PeeringAttachmentAccepterArgs(
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayAttachmentId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepterArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepterArgs =
        com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepterArgs.builder()
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayAttachmentId(transitGatewayAttachmentId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PeeringAttachmentAccepterArgs].
 */
@PulumiTagMarker
public class PeeringAttachmentAccepterArgsBuilder internal constructor() {
    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayAttachmentId: Output<String>? = null

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("irlyasumpuiwhjju")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the EC2 Transit Gateway Peering Attachment to manage.
     */
    @JvmName("ciolfdkryvpyqcbn")
    public suspend fun transitGatewayAttachmentId(`value`: Output<String>) {
        this.transitGatewayAttachmentId = value
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bojagxcegjsbnpfh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lrlsxmswsrxgbytf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the EC2 Transit Gateway Peering Attachment to manage.
     */
    @JvmName("xsghaerhfsteisod")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAttachmentId = mapped
    }

    internal fun build(): PeeringAttachmentAccepterArgs = PeeringAttachmentAccepterArgs(
        tags = tags,
        transitGatewayAttachmentId = transitGatewayAttachmentId,
    )
}
