@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.PeeringAttachmentArgs.builder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.PeeringAttachmentOptionsArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.PeeringAttachmentOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway Peering Attachment.
 * For examples of custom route table association and propagation, see the [EC2 Transit Gateway Networking Examples Guide](https://docs.aws.amazon.com/vpc/latest/tgw/TGW_Scenarios.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const peer = aws.getRegion({});
 * const local = new aws.ec2transitgateway.TransitGateway("local", {tags: {
 *     Name: "Local TGW",
 * }});
 * const peerTransitGateway = new aws.ec2transitgateway.TransitGateway("peer", {tags: {
 *     Name: "Peer TGW",
 * }});
 * const example = new aws.ec2transitgateway.PeeringAttachment("example", {
 *     peerAccountId: peerTransitGateway.ownerId,
 *     peerRegion: peer.then(peer => peer.name),
 *     peerTransitGatewayId: peerTransitGateway.id,
 *     transitGatewayId: local.id,
 *     tags: {
 *         Name: "TGW Peering Requestor",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * peer = aws.get_region()
 * local = aws.ec2transitgateway.TransitGateway("local", tags={
 *     "Name": "Local TGW",
 * })
 * peer_transit_gateway = aws.ec2transitgateway.TransitGateway("peer", tags={
 *     "Name": "Peer TGW",
 * })
 * example = aws.ec2transitgateway.PeeringAttachment("example",
 *     peer_account_id=peer_transit_gateway.owner_id,
 *     peer_region=peer.name,
 *     peer_transit_gateway_id=peer_transit_gateway.id,
 *     transit_gateway_id=local.id,
 *     tags={
 *         "Name": "TGW Peering Requestor",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var peer = Aws.GetRegion.Invoke();
 *     var local = new Aws.Ec2TransitGateway.TransitGateway("local", new()
 *     {
 *         Tags =
 *         {
 *             { "Name", "Local TGW" },
 *         },
 *     });
 *     var peerTransitGateway = new Aws.Ec2TransitGateway.TransitGateway("peer", new()
 *     {
 *         Tags =
 *         {
 *             { "Name", "Peer TGW" },
 *         },
 *     });
 *     var example = new Aws.Ec2TransitGateway.PeeringAttachment("example", new()
 *     {
 *         PeerAccountId = peerTransitGateway.OwnerId,
 *         PeerRegion = peer.Apply(getRegionResult => getRegionResult.Name),
 *         PeerTransitGatewayId = peerTransitGateway.Id,
 *         TransitGatewayId = local.Id,
 *         Tags =
 *         {
 *             { "Name", "TGW Peering Requestor" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		peer, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		local, err := ec2transitgateway.NewTransitGateway(ctx, "local", &ec2transitgateway.TransitGatewayArgs{
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Local TGW"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		peerTransitGateway, err := ec2transitgateway.NewTransitGateway(ctx, "peer", &ec2transitgateway.TransitGatewayArgs{
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Peer TGW"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2transitgateway.NewPeeringAttachment(ctx, "example", &ec2transitgateway.PeeringAttachmentArgs{
 * 			PeerAccountId:        peerTransitGateway.OwnerId,
 * 			PeerRegion:           pulumi.String(peer.Name),
 * 			PeerTransitGatewayId: peerTransitGateway.ID(),
 * 			TransitGatewayId:     local.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("TGW Peering Requestor"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import com.pulumi.aws.ec2transitgateway.PeeringAttachment;
 * import com.pulumi.aws.ec2transitgateway.PeeringAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var peer = AwsFunctions.getRegion();
 *         var local = new TransitGateway("local", TransitGatewayArgs.builder()
 *             .tags(Map.of("Name", "Local TGW"))
 *             .build());
 *         var peerTransitGateway = new TransitGateway("peerTransitGateway", TransitGatewayArgs.builder()
 *             .tags(Map.of("Name", "Peer TGW"))
 *             .build());
 *         var example = new PeeringAttachment("example", PeeringAttachmentArgs.builder()
 *             .peerAccountId(peerTransitGateway.ownerId())
 *             .peerRegion(peer.applyValue(getRegionResult -> getRegionResult.name()))
 *             .peerTransitGatewayId(peerTransitGateway.id())
 *             .transitGatewayId(local.id())
 *             .tags(Map.of("Name", "TGW Peering Requestor"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   local:
 *     type: aws:ec2transitgateway:TransitGateway
 *     properties:
 *       tags:
 *         Name: Local TGW
 *   peerTransitGateway:
 *     type: aws:ec2transitgateway:TransitGateway
 *     name: peer
 *     properties:
 *       tags:
 *         Name: Peer TGW
 *   example:
 *     type: aws:ec2transitgateway:PeeringAttachment
 *     properties:
 *       peerAccountId: ${peerTransitGateway.ownerId}
 *       peerRegion: ${peer.name}
 *       peerTransitGatewayId: ${peerTransitGateway.id}
 *       transitGatewayId: ${local.id}
 *       tags:
 *         Name: TGW Peering Requestor
 * variables:
 *   peer:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_peering_attachment` using the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 * $ pulumi import aws:ec2transitgateway/peeringAttachment:PeeringAttachment example tgw-attach-12345678
 * ```
 * @property options Describes whether dynamic routing is enabled or disabled for the transit gateway peering request. See options below for more details!
 * @property peerAccountId Account ID of EC2 Transit Gateway to peer with. Defaults to the account ID the AWS provider is currently connected to.
 * @property peerRegion Region of EC2 Transit Gateway to peer with.
 * @property peerTransitGatewayId Identifier of EC2 Transit Gateway to peer with.
 * @property tags Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayId Identifier of EC2 Transit Gateway.
 */
public data class PeeringAttachmentArgs(
    public val options: Output<PeeringAttachmentOptionsArgs>? = null,
    public val peerAccountId: Output<String>? = null,
    public val peerRegion: Output<String>? = null,
    public val peerTransitGatewayId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.PeeringAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.PeeringAttachmentArgs =
        com.pulumi.aws.ec2transitgateway.PeeringAttachmentArgs.builder()
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .peerAccountId(peerAccountId?.applyValue({ args0 -> args0 }))
            .peerRegion(peerRegion?.applyValue({ args0 -> args0 }))
            .peerTransitGatewayId(peerTransitGatewayId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayId(transitGatewayId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PeeringAttachmentArgs].
 */
@PulumiTagMarker
public class PeeringAttachmentArgsBuilder internal constructor() {
    private var options: Output<PeeringAttachmentOptionsArgs>? = null

    private var peerAccountId: Output<String>? = null

    private var peerRegion: Output<String>? = null

    private var peerTransitGatewayId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayId: Output<String>? = null

    /**
     * @param value Describes whether dynamic routing is enabled or disabled for the transit gateway peering request. See options below for more details!
     */
    @JvmName("hjofeoptrmpnhrcj")
    public suspend fun options(`value`: Output<PeeringAttachmentOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value Account ID of EC2 Transit Gateway to peer with. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("gtqpueqyacyfdhmo")
    public suspend fun peerAccountId(`value`: Output<String>) {
        this.peerAccountId = value
    }

    /**
     * @param value Region of EC2 Transit Gateway to peer with.
     */
    @JvmName("wghcldhpuxprbsmn")
    public suspend fun peerRegion(`value`: Output<String>) {
        this.peerRegion = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway to peer with.
     */
    @JvmName("woiwbbnfjctqvxgs")
    public suspend fun peerTransitGatewayId(`value`: Output<String>) {
        this.peerTransitGatewayId = value
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tbefkjosahlwrdwg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway.
     */
    @JvmName("rodubffvofgvtbpg")
    public suspend fun transitGatewayId(`value`: Output<String>) {
        this.transitGatewayId = value
    }

    /**
     * @param value Describes whether dynamic routing is enabled or disabled for the transit gateway peering request. See options below for more details!
     */
    @JvmName("mnropervvftjmuul")
    public suspend fun options(`value`: PeeringAttachmentOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument Describes whether dynamic routing is enabled or disabled for the transit gateway peering request. See options below for more details!
     */
    @JvmName("rhxhecxlyrjpjhjx")
    public suspend fun options(argument: suspend PeeringAttachmentOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = PeeringAttachmentOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value Account ID of EC2 Transit Gateway to peer with. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("cmrxcviqwiyajkus")
    public suspend fun peerAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAccountId = mapped
    }

    /**
     * @param value Region of EC2 Transit Gateway to peer with.
     */
    @JvmName("gtfjowvjtyggmqmk")
    public suspend fun peerRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerRegion = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway to peer with.
     */
    @JvmName("vjwbqggeetddlxpf")
    public suspend fun peerTransitGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerTransitGatewayId = mapped
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xrktkuewinkqgppt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aflnjexsunbbpclf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway.
     */
    @JvmName("cwhrtafhubjlkoxd")
    public suspend fun transitGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayId = mapped
    }

    internal fun build(): PeeringAttachmentArgs = PeeringAttachmentArgs(
        options = options,
        peerAccountId = peerAccountId,
        peerRegion = peerRegion,
        peerTransitGatewayId = peerTransitGatewayId,
        tags = tags,
        transitGatewayId = transitGatewayId,
    )
}
