@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.PolicyTableAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway Policy Table association.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.PolicyTableAssociation("example", {
 *     transitGatewayAttachmentId: exampleAwsNetworkmanagerTransitGatewayPeering.transitGatewayPeeringAttachmentId,
 *     transitGatewayPolicyTableId: exampleAwsEc2TransitGatewayPolicyTable.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.PolicyTableAssociation("example",
 *     transit_gateway_attachment_id=example_aws_networkmanager_transit_gateway_peering["transitGatewayPeeringAttachmentId"],
 *     transit_gateway_policy_table_id=example_aws_ec2_transit_gateway_policy_table["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.PolicyTableAssociation("example", new()
 *     {
 *         TransitGatewayAttachmentId = exampleAwsNetworkmanagerTransitGatewayPeering.TransitGatewayPeeringAttachmentId,
 *         TransitGatewayPolicyTableId = exampleAwsEc2TransitGatewayPolicyTable.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2transitgateway.NewPolicyTableAssociation(ctx, "example", &ec2transitgateway.PolicyTableAssociationArgs{
 * 			TransitGatewayAttachmentId:  pulumi.Any(exampleAwsNetworkmanagerTransitGatewayPeering.TransitGatewayPeeringAttachmentId),
 * 			TransitGatewayPolicyTableId: pulumi.Any(exampleAwsEc2TransitGatewayPolicyTable.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.PolicyTableAssociation;
 * import com.pulumi.aws.ec2transitgateway.PolicyTableAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PolicyTableAssociation("example", PolicyTableAssociationArgs.builder()
 *             .transitGatewayAttachmentId(exampleAwsNetworkmanagerTransitGatewayPeering.transitGatewayPeeringAttachmentId())
 *             .transitGatewayPolicyTableId(exampleAwsEc2TransitGatewayPolicyTable.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:PolicyTableAssociation
 *     properties:
 *       transitGatewayAttachmentId: ${exampleAwsNetworkmanagerTransitGatewayPeering.transitGatewayPeeringAttachmentId}
 *       transitGatewayPolicyTableId: ${exampleAwsEc2TransitGatewayPolicyTable.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_policy_table_association` using the EC2 Transit Gateway Policy Table identifier, an underscore, and the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 * $ pulumi import aws:ec2transitgateway/policyTableAssociation:PolicyTableAssociation example tgw-rtb-12345678_tgw-attach-87654321
 * ```
 * @property transitGatewayAttachmentId Identifier of EC2 Transit Gateway Attachment.
 * @property transitGatewayPolicyTableId Identifier of EC2 Transit Gateway Policy Table.
 */
public data class PolicyTableAssociationArgs(
    public val transitGatewayAttachmentId: Output<String>? = null,
    public val transitGatewayPolicyTableId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.PolicyTableAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.PolicyTableAssociationArgs =
        com.pulumi.aws.ec2transitgateway.PolicyTableAssociationArgs.builder()
            .transitGatewayAttachmentId(transitGatewayAttachmentId?.applyValue({ args0 -> args0 }))
            .transitGatewayPolicyTableId(transitGatewayPolicyTableId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyTableAssociationArgs].
 */
@PulumiTagMarker
public class PolicyTableAssociationArgsBuilder internal constructor() {
    private var transitGatewayAttachmentId: Output<String>? = null

    private var transitGatewayPolicyTableId: Output<String>? = null

    /**
     * @param value Identifier of EC2 Transit Gateway Attachment.
     */
    @JvmName("txlkqexuuascjqya")
    public suspend fun transitGatewayAttachmentId(`value`: Output<String>) {
        this.transitGatewayAttachmentId = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Policy Table.
     */
    @JvmName("aalhnuywtaoswbsj")
    public suspend fun transitGatewayPolicyTableId(`value`: Output<String>) {
        this.transitGatewayPolicyTableId = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Attachment.
     */
    @JvmName("gsgjpmsxiurypwjf")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAttachmentId = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Policy Table.
     */
    @JvmName("talfxmcbeviyrypm")
    public suspend fun transitGatewayPolicyTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayPolicyTableId = mapped
    }

    internal fun build(): PolicyTableAssociationArgs = PolicyTableAssociationArgs(
        transitGatewayAttachmentId = transitGatewayAttachmentId,
        transitGatewayPolicyTableId = transitGatewayPolicyTableId,
    )
}
