@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PrefixListReference].
 */
@PulumiTagMarker
public class PrefixListReferenceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrefixListReferenceArgs = PrefixListReferenceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrefixListReferenceArgsBuilder.() -> Unit) {
        val builder = PrefixListReferenceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrefixListReference {
        val builtJavaResource =
            com.pulumi.aws.ec2transitgateway.PrefixListReference(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrefixListReference(builtJavaResource)
    }
}

/**
 * Manages an EC2 Transit Gateway Prefix List Reference.
 * ## Example Usage
 * ### Attachment Routing
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.PrefixListReference("example", {
 *     prefixListId: exampleAwsEc2ManagedPrefixList.id,
 *     transitGatewayAttachmentId: exampleAwsEc2TransitGatewayVpcAttachment.id,
 *     transitGatewayRouteTableId: exampleAwsEc2TransitGateway.associationDefaultRouteTableId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.PrefixListReference("example",
 *     prefix_list_id=example_aws_ec2_managed_prefix_list["id"],
 *     transit_gateway_attachment_id=example_aws_ec2_transit_gateway_vpc_attachment["id"],
 *     transit_gateway_route_table_id=example_aws_ec2_transit_gateway["associationDefaultRouteTableId"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.PrefixListReference("example", new()
 *     {
 *         PrefixListId = exampleAwsEc2ManagedPrefixList.Id,
 *         TransitGatewayAttachmentId = exampleAwsEc2TransitGatewayVpcAttachment.Id,
 *         TransitGatewayRouteTableId = exampleAwsEc2TransitGateway.AssociationDefaultRouteTableId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2transitgateway.NewPrefixListReference(ctx, "example", &ec2transitgateway.PrefixListReferenceArgs{
 * 			PrefixListId:               pulumi.Any(exampleAwsEc2ManagedPrefixList.Id),
 * 			TransitGatewayAttachmentId: pulumi.Any(exampleAwsEc2TransitGatewayVpcAttachment.Id),
 * 			TransitGatewayRouteTableId: pulumi.Any(exampleAwsEc2TransitGateway.AssociationDefaultRouteTableId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.PrefixListReference;
 * import com.pulumi.aws.ec2transitgateway.PrefixListReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PrefixListReference("example", PrefixListReferenceArgs.builder()
 *             .prefixListId(exampleAwsEc2ManagedPrefixList.id())
 *             .transitGatewayAttachmentId(exampleAwsEc2TransitGatewayVpcAttachment.id())
 *             .transitGatewayRouteTableId(exampleAwsEc2TransitGateway.associationDefaultRouteTableId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:PrefixListReference
 *     properties:
 *       prefixListId: ${exampleAwsEc2ManagedPrefixList.id}
 *       transitGatewayAttachmentId: ${exampleAwsEc2TransitGatewayVpcAttachment.id}
 *       transitGatewayRouteTableId: ${exampleAwsEc2TransitGateway.associationDefaultRouteTableId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Blackhole Routing
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.PrefixListReference("example", {
 *     blackhole: true,
 *     prefixListId: exampleAwsEc2ManagedPrefixList.id,
 *     transitGatewayRouteTableId: exampleAwsEc2TransitGateway.associationDefaultRouteTableId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.PrefixListReference("example",
 *     blackhole=True,
 *     prefix_list_id=example_aws_ec2_managed_prefix_list["id"],
 *     transit_gateway_route_table_id=example_aws_ec2_transit_gateway["associationDefaultRouteTableId"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.PrefixListReference("example", new()
 *     {
 *         Blackhole = true,
 *         PrefixListId = exampleAwsEc2ManagedPrefixList.Id,
 *         TransitGatewayRouteTableId = exampleAwsEc2TransitGateway.AssociationDefaultRouteTableId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2transitgateway.NewPrefixListReference(ctx, "example", &ec2transitgateway.PrefixListReferenceArgs{
 * 			Blackhole:                  pulumi.Bool(true),
 * 			PrefixListId:               pulumi.Any(exampleAwsEc2ManagedPrefixList.Id),
 * 			TransitGatewayRouteTableId: pulumi.Any(exampleAwsEc2TransitGateway.AssociationDefaultRouteTableId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.PrefixListReference;
 * import com.pulumi.aws.ec2transitgateway.PrefixListReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PrefixListReference("example", PrefixListReferenceArgs.builder()
 *             .blackhole(true)
 *             .prefixListId(exampleAwsEc2ManagedPrefixList.id())
 *             .transitGatewayRouteTableId(exampleAwsEc2TransitGateway.associationDefaultRouteTableId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:PrefixListReference
 *     properties:
 *       blackhole: true
 *       prefixListId: ${exampleAwsEc2ManagedPrefixList.id}
 *       transitGatewayRouteTableId: ${exampleAwsEc2TransitGateway.associationDefaultRouteTableId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_prefix_list_reference` using the EC2 Transit Gateway Route Table identifier and EC2 Prefix List identifier, separated by an underscore (`_`). For example:
 * ```sh
 * $ pulumi import aws:ec2transitgateway/prefixListReference:PrefixListReference example tgw-rtb-12345678_pl-12345678
 * ```
 */
public class PrefixListReference internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.PrefixListReference,
) : KotlinCustomResource(javaResource, PrefixListReferenceMapper) {
    /**
     * Indicates whether to drop traffic that matches the Prefix List. Defaults to `false`.
     */
    public val blackhole: Output<Boolean>?
        get() = javaResource.blackhole().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Identifier of EC2 Prefix List.
     */
    public val prefixListId: Output<String>
        get() = javaResource.prefixListId().applyValue({ args0 -> args0 })

    public val prefixListOwnerId: Output<String>
        get() = javaResource.prefixListOwnerId().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 Transit Gateway Attachment.
     */
    public val transitGatewayAttachmentId: Output<String>?
        get() = javaResource.transitGatewayAttachmentId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of EC2 Transit Gateway Route Table.
     * The following arguments are optional:
     */
    public val transitGatewayRouteTableId: Output<String>
        get() = javaResource.transitGatewayRouteTableId().applyValue({ args0 -> args0 })
}

public object PrefixListReferenceMapper : ResourceMapper<PrefixListReference> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.PrefixListReference::class == javaResource::class

    override fun map(javaResource: Resource): PrefixListReference = PrefixListReference(
        javaResource
            as com.pulumi.aws.ec2transitgateway.PrefixListReference,
    )
}

/**
 * @see [PrefixListReference].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrefixListReference].
 */
public suspend fun prefixListReference(
    name: String,
    block: suspend PrefixListReferenceResourceBuilder.() -> Unit,
): PrefixListReference {
    val builder = PrefixListReferenceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrefixListReference].
 * @param name The _unique_ name of the resulting resource.
 */
public fun prefixListReference(name: String): PrefixListReference {
    val builder = PrefixListReferenceResourceBuilder()
    builder.name(name)
    return builder.build()
}
