@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [RouteTable].
 */
@PulumiTagMarker
public class RouteTableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteTableArgs = RouteTableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteTableArgsBuilder.() -> Unit) {
        val builder = RouteTableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RouteTable {
        val builtJavaResource = com.pulumi.aws.ec2transitgateway.RouteTable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RouteTable(builtJavaResource)
    }
}

/**
 * Manages an EC2 Transit Gateway Route Table.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.RouteTable("example", {transitGatewayId: exampleAwsEc2TransitGateway.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.RouteTable("example", transit_gateway_id=example_aws_ec2_transit_gateway["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.RouteTable("example", new()
 *     {
 *         TransitGatewayId = exampleAwsEc2TransitGateway.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2transitgateway.NewRouteTable(ctx, "example", &ec2transitgateway.RouteTableArgs{
 * 			TransitGatewayId: pulumi.Any(exampleAwsEc2TransitGateway.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.RouteTable;
 * import com.pulumi.aws.ec2transitgateway.RouteTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RouteTable("example", RouteTableArgs.builder()
 *             .transitGatewayId(exampleAwsEc2TransitGateway.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:RouteTable
 *     properties:
 *       transitGatewayId: ${exampleAwsEc2TransitGateway.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_route_table` using the EC2 Transit Gateway Route Table identifier. For example:
 * ```sh
 * $ pulumi import aws:ec2transitgateway/routeTable:RouteTable example tgw-rtb-12345678
 * ```
 */
public class RouteTable internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.RouteTable,
) : KotlinCustomResource(javaResource, RouteTableMapper) {
    /**
     * EC2 Transit Gateway Route Table Amazon Resource Name (ARN).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Boolean whether this is the default association route table for the EC2 Transit Gateway.
     */
    public val defaultAssociationRouteTable: Output<Boolean>
        get() = javaResource.defaultAssociationRouteTable().applyValue({ args0 -> args0 })

    /**
     * Boolean whether this is the default propagation route table for the EC2 Transit Gateway.
     */
    public val defaultPropagationRouteTable: Output<Boolean>
        get() = javaResource.defaultPropagationRouteTable().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the EC2 Transit Gateway Route Table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Identifier of EC2 Transit Gateway.
     */
    public val transitGatewayId: Output<String>
        get() = javaResource.transitGatewayId().applyValue({ args0 -> args0 })
}

public object RouteTableMapper : ResourceMapper<RouteTable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.RouteTable::class == javaResource::class

    override fun map(javaResource: Resource): RouteTable = RouteTable(
        javaResource as
            com.pulumi.aws.ec2transitgateway.RouteTable,
    )
}

/**
 * @see [RouteTable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouteTable].
 */
public suspend fun routeTable(name: String, block: suspend RouteTableResourceBuilder.() -> Unit): RouteTable {
    val builder = RouteTableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouteTable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routeTable(name: String): RouteTable {
    val builder = RouteTableResourceBuilder()
    builder.name(name)
    return builder.build()
}
