@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.RouteTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway Route Table.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.RouteTable("example", {transitGatewayId: exampleAwsEc2TransitGateway.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.RouteTable("example", transit_gateway_id=example_aws_ec2_transit_gateway["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.RouteTable("example", new()
 *     {
 *         TransitGatewayId = exampleAwsEc2TransitGateway.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2transitgateway.NewRouteTable(ctx, "example", &ec2transitgateway.RouteTableArgs{
 * 			TransitGatewayId: pulumi.Any(exampleAwsEc2TransitGateway.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.RouteTable;
 * import com.pulumi.aws.ec2transitgateway.RouteTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RouteTable("example", RouteTableArgs.builder()
 *             .transitGatewayId(exampleAwsEc2TransitGateway.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:RouteTable
 *     properties:
 *       transitGatewayId: ${exampleAwsEc2TransitGateway.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_route_table` using the EC2 Transit Gateway Route Table identifier. For example:
 * ```sh
 * $ pulumi import aws:ec2transitgateway/routeTable:RouteTable example tgw-rtb-12345678
 * ```
 * @property tags Key-value tags for the EC2 Transit Gateway Route Table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayId Identifier of EC2 Transit Gateway.
 */
public data class RouteTableArgs(
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.RouteTableArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.RouteTableArgs =
        com.pulumi.aws.ec2transitgateway.RouteTableArgs.builder()
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayId(transitGatewayId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteTableArgs].
 */
@PulumiTagMarker
public class RouteTableArgsBuilder internal constructor() {
    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayId: Output<String>? = null

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Route Table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mthculsgolxlhpke")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway.
     */
    @JvmName("arpsgykvaceggiir")
    public suspend fun transitGatewayId(`value`: Output<String>) {
        this.transitGatewayId = value
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Route Table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vglihllnxsaipvcc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway Route Table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ttkgjnjwvcyedtsh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway.
     */
    @JvmName("uyhxaebmxkrgdang")
    public suspend fun transitGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayId = mapped
    }

    internal fun build(): RouteTableArgs = RouteTableArgs(
        tags = tags,
        transitGatewayId = transitGatewayId,
    )
}
