@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.RouteTableAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway Route Table association.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.RouteTableAssociation("example", {
 *     transitGatewayAttachmentId: exampleAwsEc2TransitGatewayVpcAttachment.id,
 *     transitGatewayRouteTableId: exampleAwsEc2TransitGatewayRouteTable.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.RouteTableAssociation("example",
 *     transit_gateway_attachment_id=example_aws_ec2_transit_gateway_vpc_attachment["id"],
 *     transit_gateway_route_table_id=example_aws_ec2_transit_gateway_route_table["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.RouteTableAssociation("example", new()
 *     {
 *         TransitGatewayAttachmentId = exampleAwsEc2TransitGatewayVpcAttachment.Id,
 *         TransitGatewayRouteTableId = exampleAwsEc2TransitGatewayRouteTable.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2transitgateway.NewRouteTableAssociation(ctx, "example", &ec2transitgateway.RouteTableAssociationArgs{
 * 			TransitGatewayAttachmentId: pulumi.Any(exampleAwsEc2TransitGatewayVpcAttachment.Id),
 * 			TransitGatewayRouteTableId: pulumi.Any(exampleAwsEc2TransitGatewayRouteTable.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.RouteTableAssociation;
 * import com.pulumi.aws.ec2transitgateway.RouteTableAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RouteTableAssociation("example", RouteTableAssociationArgs.builder()
 *             .transitGatewayAttachmentId(exampleAwsEc2TransitGatewayVpcAttachment.id())
 *             .transitGatewayRouteTableId(exampleAwsEc2TransitGatewayRouteTable.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:RouteTableAssociation
 *     properties:
 *       transitGatewayAttachmentId: ${exampleAwsEc2TransitGatewayVpcAttachment.id}
 *       transitGatewayRouteTableId: ${exampleAwsEc2TransitGatewayRouteTable.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_route_table_association` using the EC2 Transit Gateway Route Table identifier, an underscore, and the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 * $ pulumi import aws:ec2transitgateway/routeTableAssociation:RouteTableAssociation example tgw-rtb-12345678_tgw-attach-87654321
 * ```
 * @property replaceExistingAssociation Boolean whether the Gateway Attachment should remove any current Route Table association before associating with the specified Route Table. Default value: `false`. This argument is intended for use with EC2 Transit Gateways shared into the current account, otherwise the `transit_gateway_default_route_table_association` argument of the `aws.ec2transitgateway.VpcAttachment` resource should be used.
 * @property transitGatewayAttachmentId Identifier of EC2 Transit Gateway Attachment.
 * @property transitGatewayRouteTableId Identifier of EC2 Transit Gateway Route Table.
 */
public data class RouteTableAssociationArgs(
    public val replaceExistingAssociation: Output<Boolean>? = null,
    public val transitGatewayAttachmentId: Output<String>? = null,
    public val transitGatewayRouteTableId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.RouteTableAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.RouteTableAssociationArgs =
        com.pulumi.aws.ec2transitgateway.RouteTableAssociationArgs.builder()
            .replaceExistingAssociation(replaceExistingAssociation?.applyValue({ args0 -> args0 }))
            .transitGatewayAttachmentId(transitGatewayAttachmentId?.applyValue({ args0 -> args0 }))
            .transitGatewayRouteTableId(transitGatewayRouteTableId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteTableAssociationArgs].
 */
@PulumiTagMarker
public class RouteTableAssociationArgsBuilder internal constructor() {
    private var replaceExistingAssociation: Output<Boolean>? = null

    private var transitGatewayAttachmentId: Output<String>? = null

    private var transitGatewayRouteTableId: Output<String>? = null

    /**
     * @param value Boolean whether the Gateway Attachment should remove any current Route Table association before associating with the specified Route Table. Default value: `false`. This argument is intended for use with EC2 Transit Gateways shared into the current account, otherwise the `transit_gateway_default_route_table_association` argument of the `aws.ec2transitgateway.VpcAttachment` resource should be used.
     */
    @JvmName("lkjxjbankmlekoel")
    public suspend fun replaceExistingAssociation(`value`: Output<Boolean>) {
        this.replaceExistingAssociation = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Attachment.
     */
    @JvmName("yabtnlciltohacsy")
    public suspend fun transitGatewayAttachmentId(`value`: Output<String>) {
        this.transitGatewayAttachmentId = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Route Table.
     */
    @JvmName("tbwafddiogblrxty")
    public suspend fun transitGatewayRouteTableId(`value`: Output<String>) {
        this.transitGatewayRouteTableId = value
    }

    /**
     * @param value Boolean whether the Gateway Attachment should remove any current Route Table association before associating with the specified Route Table. Default value: `false`. This argument is intended for use with EC2 Transit Gateways shared into the current account, otherwise the `transit_gateway_default_route_table_association` argument of the `aws.ec2transitgateway.VpcAttachment` resource should be used.
     */
    @JvmName("liawkntesdaeieoq")
    public suspend fun replaceExistingAssociation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replaceExistingAssociation = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Attachment.
     */
    @JvmName("vbmfchgevhqwesfq")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAttachmentId = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Route Table.
     */
    @JvmName("xchbidoujdjqtgnd")
    public suspend fun transitGatewayRouteTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayRouteTableId = mapped
    }

    internal fun build(): RouteTableAssociationArgs = RouteTableAssociationArgs(
        replaceExistingAssociation = replaceExistingAssociation,
        transitGatewayAttachmentId = transitGatewayAttachmentId,
        transitGatewayRouteTableId = transitGatewayRouteTableId,
    )
}
