@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RouteTablePropagation].
 */
@PulumiTagMarker
public class RouteTablePropagationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteTablePropagationArgs = RouteTablePropagationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteTablePropagationArgsBuilder.() -> Unit) {
        val builder = RouteTablePropagationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RouteTablePropagation {
        val builtJavaResource =
            com.pulumi.aws.ec2transitgateway.RouteTablePropagation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RouteTablePropagation(builtJavaResource)
    }
}

/**
 * Manages an EC2 Transit Gateway Route Table propagation.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.RouteTablePropagation("example", {
 *     transitGatewayAttachmentId: exampleAwsEc2TransitGatewayVpcAttachment.id,
 *     transitGatewayRouteTableId: exampleAwsEc2TransitGatewayRouteTable.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.RouteTablePropagation("example",
 *     transit_gateway_attachment_id=example_aws_ec2_transit_gateway_vpc_attachment["id"],
 *     transit_gateway_route_table_id=example_aws_ec2_transit_gateway_route_table["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.RouteTablePropagation("example", new()
 *     {
 *         TransitGatewayAttachmentId = exampleAwsEc2TransitGatewayVpcAttachment.Id,
 *         TransitGatewayRouteTableId = exampleAwsEc2TransitGatewayRouteTable.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2transitgateway.NewRouteTablePropagation(ctx, "example", &ec2transitgateway.RouteTablePropagationArgs{
 * 			TransitGatewayAttachmentId: pulumi.Any(exampleAwsEc2TransitGatewayVpcAttachment.Id),
 * 			TransitGatewayRouteTableId: pulumi.Any(exampleAwsEc2TransitGatewayRouteTable.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.RouteTablePropagation;
 * import com.pulumi.aws.ec2transitgateway.RouteTablePropagationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RouteTablePropagation("example", RouteTablePropagationArgs.builder()
 *             .transitGatewayAttachmentId(exampleAwsEc2TransitGatewayVpcAttachment.id())
 *             .transitGatewayRouteTableId(exampleAwsEc2TransitGatewayRouteTable.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:RouteTablePropagation
 *     properties:
 *       transitGatewayAttachmentId: ${exampleAwsEc2TransitGatewayVpcAttachment.id}
 *       transitGatewayRouteTableId: ${exampleAwsEc2TransitGatewayRouteTable.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_route_table_propagation` using the EC2 Transit Gateway Route Table identifier, an underscore, and the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 * $ pulumi import aws:ec2transitgateway/routeTablePropagation:RouteTablePropagation example tgw-rtb-12345678_tgw-attach-87654321
 * ```
 */
public class RouteTablePropagation internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.RouteTablePropagation,
) : KotlinCustomResource(javaResource, RouteTablePropagationMapper) {
    /**
     * Identifier of the resource
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * Type of the resource
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 Transit Gateway Attachment.
     */
    public val transitGatewayAttachmentId: Output<String>
        get() = javaResource.transitGatewayAttachmentId().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 Transit Gateway Route Table.
     */
    public val transitGatewayRouteTableId: Output<String>
        get() = javaResource.transitGatewayRouteTableId().applyValue({ args0 -> args0 })
}

public object RouteTablePropagationMapper : ResourceMapper<RouteTablePropagation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.RouteTablePropagation::class == javaResource::class

    override fun map(javaResource: Resource): RouteTablePropagation =
        RouteTablePropagation(javaResource as com.pulumi.aws.ec2transitgateway.RouteTablePropagation)
}

/**
 * @see [RouteTablePropagation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouteTablePropagation].
 */
public suspend fun routeTablePropagation(
    name: String,
    block: suspend RouteTablePropagationResourceBuilder.() -> Unit,
): RouteTablePropagation {
    val builder = RouteTablePropagationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouteTablePropagation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routeTablePropagation(name: String): RouteTablePropagation {
    val builder = RouteTablePropagationResourceBuilder()
    builder.name(name)
    return builder.build()
}
