@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VpcAttachment].
 */
@PulumiTagMarker
public class VpcAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcAttachmentArgs = VpcAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcAttachmentArgsBuilder.() -> Unit) {
        val builder = VpcAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcAttachment {
        val builtJavaResource = com.pulumi.aws.ec2transitgateway.VpcAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcAttachment(builtJavaResource)
    }
}

/**
 * Manages an EC2 Transit Gateway VPC Attachment. For examples of custom route table association and propagation, see the EC2 Transit Gateway Networking Examples Guide.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.VpcAttachment("example", {
 *     subnetIds: [exampleAwsSubnet&#46;id],
 *     transitGatewayId: exampleAwsEc2TransitGateway.id,
 *     vpcId: exampleAwsVpc.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.VpcAttachment("example",
 *     subnet_ids=[example_aws_subnet["id"]],
 *     transit_gateway_id=example_aws_ec2_transit_gateway["id"],
 *     vpc_id=example_aws_vpc["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.VpcAttachment("example", new()
 *     {
 *         SubnetIds = new[]
 *         {
 *             exampleAwsSubnet.Id,
 *         },
 *         TransitGatewayId = exampleAwsEc2TransitGateway.Id,
 *         VpcId = exampleAwsVpc.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2transitgateway.NewVpcAttachment(ctx, "example", &ec2transitgateway.VpcAttachmentArgs{
 * 			SubnetIds: pulumi.StringArray{
 * 				exampleAwsSubnet.Id,
 * 			},
 * 			TransitGatewayId: pulumi.Any(exampleAwsEc2TransitGateway.Id),
 * 			VpcId:            pulumi.Any(exampleAwsVpc.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachment;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetIds(exampleAwsSubnet.id())
 *             .transitGatewayId(exampleAwsEc2TransitGateway.id())
 *             .vpcId(exampleAwsVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:VpcAttachment
 *     properties:
 *       subnetIds:
 *         - ${exampleAwsSubnet.id}
 *       transitGatewayId: ${exampleAwsEc2TransitGateway.id}
 *       vpcId: ${exampleAwsVpc.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_vpc_attachment` using the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 * $ pulumi import aws:ec2transitgateway/vpcAttachment:VpcAttachment example tgw-attach-12345678
 * ```
 */
public class VpcAttachment internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.VpcAttachment,
) : KotlinCustomResource(javaResource, VpcAttachmentMapper) {
    /**
     * Whether Appliance Mode support is enabled. If enabled, a traffic flow between a source and destination uses the same Availability Zone for the VPC attachment for the lifetime of that flow. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    public val applianceModeSupport: Output<String>?
        get() = javaResource.applianceModeSupport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether DNS support is enabled. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    public val dnsSupport: Output<String>?
        get() = javaResource.dnsSupport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether IPv6 support is enabled. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    public val ipv6Support: Output<String>?
        get() = javaResource.ipv6Support().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifiers of EC2 Subnets.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key-value tags for the EC2 Transit Gateway VPC Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Boolean whether the VPC Attachment should be associated with the EC2 Transit Gateway association default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
     */
    public val transitGatewayDefaultRouteTableAssociation: Output<Boolean>
        get() = javaResource.transitGatewayDefaultRouteTableAssociation().applyValue({ args0 -> args0 })

    /**
     * Boolean whether the VPC Attachment should propagate routes with the EC2 Transit Gateway propagation default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
     */
    public val transitGatewayDefaultRouteTablePropagation: Output<Boolean>
        get() = javaResource.transitGatewayDefaultRouteTablePropagation().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 Transit Gateway.
     */
    public val transitGatewayId: Output<String>
        get() = javaResource.transitGatewayId().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * Identifier of the AWS account that owns the EC2 VPC.
     */
    public val vpcOwnerId: Output<String>
        get() = javaResource.vpcOwnerId().applyValue({ args0 -> args0 })
}

public object VpcAttachmentMapper : ResourceMapper<VpcAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.VpcAttachment::class == javaResource::class

    override fun map(javaResource: Resource): VpcAttachment = VpcAttachment(
        javaResource as
            com.pulumi.aws.ec2transitgateway.VpcAttachment,
    )
}

/**
 * @see [VpcAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcAttachment].
 */
public suspend fun vpcAttachment(
    name: String,
    block: suspend VpcAttachmentResourceBuilder.() -> Unit,
): VpcAttachment {
    val builder = VpcAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcAttachment(name: String): VpcAttachment {
    val builder = VpcAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
