@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VpcAttachmentAccepter].
 */
@PulumiTagMarker
public class VpcAttachmentAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcAttachmentAccepterArgs = VpcAttachmentAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcAttachmentAccepterArgsBuilder.() -> Unit) {
        val builder = VpcAttachmentAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcAttachmentAccepter {
        val builtJavaResource =
            com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VpcAttachmentAccepter(builtJavaResource)
    }
}

/**
 * Manages the accepter's side of an EC2 Transit Gateway VPC Attachment.
 * When a cross-account (requester's AWS account differs from the accepter's AWS account) EC2 Transit Gateway VPC Attachment
 * is created, an EC2 Transit Gateway VPC Attachment resource is automatically created in the accepter's account.
 * The requester can use the `aws.ec2transitgateway.VpcAttachment` resource to manage its side of the connection
 * and the accepter can use the `aws.ec2transitgateway.VpcAttachmentAccepter` resource to "adopt" its side of the
 * connection into management.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.VpcAttachmentAccepter("example", {
 *     transitGatewayAttachmentId: exampleAwsEc2TransitGatewayVpcAttachment.id,
 *     tags: {
 *         Name: "Example cross-account attachment",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.VpcAttachmentAccepter("example",
 *     transit_gateway_attachment_id=example_aws_ec2_transit_gateway_vpc_attachment["id"],
 *     tags={
 *         "Name": "Example cross-account attachment",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.VpcAttachmentAccepter("example", new()
 *     {
 *         TransitGatewayAttachmentId = exampleAwsEc2TransitGatewayVpcAttachment.Id,
 *         Tags =
 *         {
 *             { "Name", "Example cross-account attachment" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2transitgateway.NewVpcAttachmentAccepter(ctx, "example", &ec2transitgateway.VpcAttachmentAccepterArgs{
 * 			TransitGatewayAttachmentId: pulumi.Any(exampleAwsEc2TransitGatewayVpcAttachment.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example cross-account attachment"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepter;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachmentAccepter("example", VpcAttachmentAccepterArgs.builder()
 *             .transitGatewayAttachmentId(exampleAwsEc2TransitGatewayVpcAttachment.id())
 *             .tags(Map.of("Name", "Example cross-account attachment"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:VpcAttachmentAccepter
 *     properties:
 *       transitGatewayAttachmentId: ${exampleAwsEc2TransitGatewayVpcAttachment.id}
 *       tags:
 *         Name: Example cross-account attachment
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_vpc_attachment_accepter` using the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 * $ pulumi import aws:ec2transitgateway/vpcAttachmentAccepter:VpcAttachmentAccepter example tgw-attach-12345678
 * ```
 */
public class VpcAttachmentAccepter internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepter,
) : KotlinCustomResource(javaResource, VpcAttachmentAccepterMapper) {
    /**
     * Whether Appliance Mode support is enabled. Valid values: `disable`, `enable`.
     */
    public val applianceModeSupport: Output<String>
        get() = javaResource.applianceModeSupport().applyValue({ args0 -> args0 })

    /**
     * Whether DNS support is enabled. Valid values: `disable`, `enable`.
     */
    public val dnsSupport: Output<String>
        get() = javaResource.dnsSupport().applyValue({ args0 -> args0 })

    /**
     * Whether IPv6 support is enabled. Valid values: `disable`, `enable`.
     */
    public val ipv6Support: Output<String>
        get() = javaResource.ipv6Support().applyValue({ args0 -> args0 })

    /**
     * Identifiers of EC2 Subnets.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key-value tags for the EC2 Transit Gateway VPC Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the EC2 Transit Gateway Attachment to manage.
     */
    public val transitGatewayAttachmentId: Output<String>
        get() = javaResource.transitGatewayAttachmentId().applyValue({ args0 -> args0 })

    /**
     * Boolean whether the VPC Attachment should be associated with the EC2 Transit Gateway association default route table. Default value: `true`.
     */
    public val transitGatewayDefaultRouteTableAssociation: Output<Boolean>?
        get() = javaResource.transitGatewayDefaultRouteTableAssociation().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Boolean whether the VPC Attachment should propagate routes with the EC2 Transit Gateway propagation default route table. Default value: `true`.
     */
    public val transitGatewayDefaultRouteTablePropagation: Output<Boolean>?
        get() = javaResource.transitGatewayDefaultRouteTablePropagation().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Identifier of EC2 Transit Gateway.
     */
    public val transitGatewayId: Output<String>
        get() = javaResource.transitGatewayId().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * Identifier of the AWS account that owns the EC2 VPC.
     */
    public val vpcOwnerId: Output<String>
        get() = javaResource.vpcOwnerId().applyValue({ args0 -> args0 })
}

public object VpcAttachmentAccepterMapper : ResourceMapper<VpcAttachmentAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepter::class == javaResource::class

    override fun map(javaResource: Resource): VpcAttachmentAccepter =
        VpcAttachmentAccepter(javaResource as com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepter)
}

/**
 * @see [VpcAttachmentAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcAttachmentAccepter].
 */
public suspend fun vpcAttachmentAccepter(
    name: String,
    block: suspend VpcAttachmentAccepterResourceBuilder.() -> Unit,
): VpcAttachmentAccepter {
    val builder = VpcAttachmentAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcAttachmentAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcAttachmentAccepter(name: String): VpcAttachmentAccepter {
    val builder = VpcAttachmentAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
