@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetAttachmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAttachment.
 * @property filters One or more configuration blocks containing name-values filters. Detailed below.
 * @property tags Key-value tags for the attachment.
 * @property transitGatewayAttachmentId ID of the attachment.
 */
public data class GetAttachmentPlainArgs(
    public val filters: List<GetAttachmentFilter>? = null,
    public val tags: Map<String, String>? = null,
    public val transitGatewayAttachmentId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetAttachmentPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetAttachmentPlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetAttachmentPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayAttachmentId(transitGatewayAttachmentId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAttachmentPlainArgs].
 */
@PulumiTagMarker
public class GetAttachmentPlainArgsBuilder internal constructor() {
    private var filters: List<GetAttachmentFilter>? = null

    private var tags: Map<String, String>? = null

    private var transitGatewayAttachmentId: String? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("bttjojnokhyfxdla")
    public suspend fun filters(`value`: List<GetAttachmentFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("rqjggoxrgykqgpkk")
    public suspend fun filters(argument: List<suspend GetAttachmentFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetAttachmentFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("gbnemgtysyrpqudp")
    public suspend fun filters(vararg argument: suspend GetAttachmentFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetAttachmentFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("rfmbbugkvlvnwkis")
    public suspend fun filters(argument: suspend GetAttachmentFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetAttachmentFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("ondpkwyyvoseiftd")
    public suspend fun filters(vararg values: GetAttachmentFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Key-value tags for the attachment.
     */
    @JvmName("iqawhovucsqjdqdd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the attachment.
     */
    @JvmName("uvmipwulnqvpmwrk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value ID of the attachment.
     */
    @JvmName("bdrnamyhbaoykeru")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitGatewayAttachmentId = mapped
    }

    internal fun build(): GetAttachmentPlainArgs = GetAttachmentPlainArgs(
        filters = filters,
        tags = tags,
        transitGatewayAttachmentId = transitGatewayAttachmentId,
    )
}
