@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAttachments.
 * @property filters One or more configuration blocks containing name-values filters. Detailed below.
 * @property tags
 */
public data class GetAttachmentsPlainArgs(
    public val filters: List<GetAttachmentsFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetAttachmentsPlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetAttachmentsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetAttachmentsPlainArgsBuilder internal constructor() {
    private var filters: List<GetAttachmentsFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("dsefyhnfhnjebgyx")
    public suspend fun filters(`value`: List<GetAttachmentsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("jjyjyhrkklypfrub")
    public suspend fun filters(argument: List<suspend GetAttachmentsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetAttachmentsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("fiuhppclbnxhbabo")
    public suspend fun filters(vararg argument: suspend GetAttachmentsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetAttachmentsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("nthjjycylbbpunuy")
    public suspend fun filters(argument: suspend GetAttachmentsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetAttachmentsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("jyelfdcipoflgjdc")
    public suspend fun filters(vararg values: GetAttachmentsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value
     */
    @JvmName("vsbdghmltaacotfw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("chcaafpvqqrgiwdo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetAttachmentsPlainArgs = GetAttachmentsPlainArgs(
        filters = filters,
        tags = tags,
    )
}
