@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetConnectPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConnect.
 * @property filters One or more configuration blocks containing name-values filters. Detailed below.
 * @property tags Key-value tags for the EC2 Transit Gateway Connect
 * @property transitGatewayConnectId Identifier of the EC2 Transit Gateway Connect.
 */
public data class GetConnectPlainArgs(
    public val filters: List<GetConnectFilter>? = null,
    public val tags: Map<String, String>? = null,
    public val transitGatewayConnectId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetConnectPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetConnectPlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetConnectPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayConnectId(transitGatewayConnectId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectPlainArgs].
 */
@PulumiTagMarker
public class GetConnectPlainArgsBuilder internal constructor() {
    private var filters: List<GetConnectFilter>? = null

    private var tags: Map<String, String>? = null

    private var transitGatewayConnectId: String? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("olxuvweamebgqwmx")
    public suspend fun filters(`value`: List<GetConnectFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("oqsqjbtegevckslr")
    public suspend fun filters(argument: List<suspend GetConnectFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetConnectFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("hclmtpyidomjcopf")
    public suspend fun filters(vararg argument: suspend GetConnectFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetConnectFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("lqdmepcsmywsapww")
    public suspend fun filters(argument: suspend GetConnectFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetConnectFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("xmwbsionexndwpbj")
    public suspend fun filters(vararg values: GetConnectFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Connect
     */
    @JvmName("euayfvratwkipnfs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway Connect
     */
    @JvmName("xvjsegnyqmcvsdht")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Identifier of the EC2 Transit Gateway Connect.
     */
    @JvmName("mfubokyfhhlwnsuy")
    public suspend fun transitGatewayConnectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitGatewayConnectId = mapped
    }

    internal fun build(): GetConnectPlainArgs = GetConnectPlainArgs(
        filters = filters,
        tags = tags,
        transitGatewayConnectId = transitGatewayConnectId,
    )
}
