@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetPeeringAttachmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPeeringAttachment.
 * @property filters One or more configuration blocks containing name-values filters. Detailed below.
 * @property id Identifier of the EC2 Transit Gateway Peering Attachment.
 * @property tags Mapping of tags, each pair of which must exactly match
 * a pair on the specific EC2 Transit Gateway Peering Attachment to retrieve.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetPeeringAttachmentPlainArgs(
    public val filters: List<GetPeeringAttachmentFilter>? = null,
    public val id: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetPeeringAttachmentPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetPeeringAttachmentPlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetPeeringAttachmentPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetPeeringAttachmentPlainArgs].
 */
@PulumiTagMarker
public class GetPeeringAttachmentPlainArgsBuilder internal constructor() {
    private var filters: List<GetPeeringAttachmentFilter>? = null

    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("cukngnieusfafjtc")
    public suspend fun filters(`value`: List<GetPeeringAttachmentFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("benoyjyardqhqwko")
    public suspend fun filters(argument: List<suspend GetPeeringAttachmentFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetPeeringAttachmentFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("bqfytgvnpquyahoj")
    public suspend fun filters(vararg argument: suspend GetPeeringAttachmentFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetPeeringAttachmentFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("equmkgetdulakdoo")
    public suspend fun filters(argument: suspend GetPeeringAttachmentFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetPeeringAttachmentFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("fwgtrgisofbjogqb")
    public suspend fun filters(vararg values: GetPeeringAttachmentFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Identifier of the EC2 Transit Gateway Peering Attachment.
     */
    @JvmName("fgifxhcgnppqupbi")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Mapping of tags, each pair of which must exactly match
     * a pair on the specific EC2 Transit Gateway Peering Attachment to retrieve.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("xdarlahqavcdxqut")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Mapping of tags, each pair of which must exactly match
     * a pair on the specific EC2 Transit Gateway Peering Attachment to retrieve.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("wxigdxjatfnvnsjs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetPeeringAttachmentPlainArgs = GetPeeringAttachmentPlainArgs(
        filters = filters,
        id = id,
        tags = tags,
    )
}
