@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetPeeringAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPeeringAttachments.
 * @property filters One or more configuration blocks containing name-values filters. Detailed below.
 */
public data class GetPeeringAttachmentsPlainArgs(
    public val filters: List<GetPeeringAttachmentsFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetPeeringAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetPeeringAttachmentsPlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetPeeringAttachmentsPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetPeeringAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetPeeringAttachmentsPlainArgsBuilder internal constructor() {
    private var filters: List<GetPeeringAttachmentsFilter>? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("hyrucpotmiuftphb")
    public suspend fun filters(`value`: List<GetPeeringAttachmentsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("svwgtvmkhpxsogxa")
    public suspend fun filters(argument: List<suspend GetPeeringAttachmentsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetPeeringAttachmentsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("fesebgccdqlvnbjc")
    public suspend fun filters(vararg argument: suspend GetPeeringAttachmentsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetPeeringAttachmentsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("jtwfytxknuumksjg")
    public suspend fun filters(argument: suspend GetPeeringAttachmentsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetPeeringAttachmentsFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("kycepdvmkrkowlpx")
    public suspend fun filters(vararg values: GetPeeringAttachmentsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetPeeringAttachmentsPlainArgs = GetPeeringAttachmentsPlainArgs(
        filters = filters,
    )
}
