@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableAssociationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouteTableAssociations.
 * @property filters Custom filter block as described below.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 * @property transitGatewayRouteTableId Identifier of EC2 Transit Gateway Route Table.
 * The following arguments are optional:
 */
public data class GetRouteTableAssociationsPlainArgs(
    public val filters: List<GetRouteTableAssociationsFilter>? = null,
    public val transitGatewayRouteTableId: String,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableAssociationsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableAssociationsPlainArgs = com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableAssociationsPlainArgs.builder()
        .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .transitGatewayRouteTableId(transitGatewayRouteTableId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouteTableAssociationsPlainArgs].
 */
@PulumiTagMarker
public class GetRouteTableAssociationsPlainArgsBuilder internal constructor() {
    private var filters: List<GetRouteTableAssociationsFilter>? = null

    private var transitGatewayRouteTableId: String? = null

    /**
     * @param value Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("durbxxlhotivbjis")
    public suspend fun filters(`value`: List<GetRouteTableAssociationsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("dtnmvldjeeibfvwx")
    public suspend fun filters(argument: List<suspend GetRouteTableAssociationsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetRouteTableAssociationsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("jdbkyihsewnbkqxh")
    public suspend fun filters(vararg argument: suspend GetRouteTableAssociationsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetRouteTableAssociationsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("rquxpdafgvwjxdpr")
    public suspend fun filters(argument: suspend GetRouteTableAssociationsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetRouteTableAssociationsFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("wtkdtkrwhaqyoith")
    public suspend fun filters(vararg values: GetRouteTableAssociationsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Route Table.
     * The following arguments are optional:
     */
    @JvmName("mnxmmwpaoalxoyxg")
    public suspend fun transitGatewayRouteTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitGatewayRouteTableId = mapped
    }

    internal fun build(): GetRouteTableAssociationsPlainArgs = GetRouteTableAssociationsPlainArgs(
        filters = filters,
        transitGatewayRouteTableId = transitGatewayRouteTableId ?: throw
            PulumiNullFieldException("transitGatewayRouteTableId"),
    )
}
