@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableRoutesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouteTableRoutes.
 * @property filters Custom filter block as described below.
 * @property transitGatewayRouteTableId Identifier of EC2 Transit Gateway Route Table.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetRouteTableRoutesPlainArgs(
    public val filters: List<GetRouteTableRoutesFilter>,
    public val transitGatewayRouteTableId: String,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableRoutesPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableRoutesPlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableRoutesPlainArgs.builder()
            .filters(filters.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .transitGatewayRouteTableId(transitGatewayRouteTableId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouteTableRoutesPlainArgs].
 */
@PulumiTagMarker
public class GetRouteTableRoutesPlainArgsBuilder internal constructor() {
    private var filters: List<GetRouteTableRoutesFilter>? = null

    private var transitGatewayRouteTableId: String? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("lprcpoxnasaknpgx")
    public suspend fun filters(`value`: List<GetRouteTableRoutesFilter>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("fneooibjyvitdmex")
    public suspend fun filters(argument: List<suspend GetRouteTableRoutesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetRouteTableRoutesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("mhbumspnlftggprl")
    public suspend fun filters(vararg argument: suspend GetRouteTableRoutesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetRouteTableRoutesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("ppfayxgbbhogkuik")
    public suspend fun filters(argument: suspend GetRouteTableRoutesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetRouteTableRoutesFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("unlknuwedkpsyvum")
    public suspend fun filters(vararg values: GetRouteTableRoutesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Route Table.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("ylwxajaxxejxyhov")
    public suspend fun transitGatewayRouteTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitGatewayRouteTableId = mapped
    }

    internal fun build(): GetRouteTableRoutesPlainArgs = GetRouteTableRoutesPlainArgs(
        filters = filters ?: throw PulumiNullFieldException("filters"),
        transitGatewayRouteTableId = transitGatewayRouteTableId ?: throw
            PulumiNullFieldException("transitGatewayRouteTableId"),
    )
}
