@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetTransitGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitGateway.
 * @property filters One or more configuration blocks containing name-values filters. Detailed below.
 * @property id Identifier of the EC2 Transit Gateway.
 * @property tags Key-value tags for the EC2 Transit Gateway
 */
public data class GetTransitGatewayPlainArgs(
    public val filters: List<GetTransitGatewayFilter>? = null,
    public val id: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetTransitGatewayPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetTransitGatewayPlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetTransitGatewayPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetTransitGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetTransitGatewayPlainArgsBuilder internal constructor() {
    private var filters: List<GetTransitGatewayFilter>? = null

    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("fqkasxfgbxkkncry")
    public suspend fun filters(`value`: List<GetTransitGatewayFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("tslmfvmjgdeybsrt")
    public suspend fun filters(argument: List<suspend GetTransitGatewayFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTransitGatewayFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("prslvuhwsdbnqatk")
    public suspend fun filters(vararg argument: suspend GetTransitGatewayFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetTransitGatewayFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("mjsnetvdehyuqgaa")
    public suspend fun filters(argument: suspend GetTransitGatewayFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetTransitGatewayFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("bkpvahxuuayahsbu")
    public suspend fun filters(vararg values: GetTransitGatewayFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Identifier of the EC2 Transit Gateway.
     */
    @JvmName("ojvrenbutcleomqe")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway
     */
    @JvmName("caolctlgriojlotp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway
     */
    @JvmName("uvotsfhytmrhcqkv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetTransitGatewayPlainArgs = GetTransitGatewayPlainArgs(
        filters = filters,
        id = id,
        tags = tags,
    )
}
