@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetVpcAttachmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcAttachment.
 * @property filters One or more configuration blocks containing name-values filters. Detailed below.
 * @property id Identifier of the EC2 Transit Gateway VPC Attachment.
 * @property tags Key-value tags for the EC2 Transit Gateway VPC Attachment
 */
public data class GetVpcAttachmentPlainArgs(
    public val filters: List<GetVpcAttachmentFilter>? = null,
    public val id: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetVpcAttachmentPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetVpcAttachmentPlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetVpcAttachmentPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetVpcAttachmentPlainArgs].
 */
@PulumiTagMarker
public class GetVpcAttachmentPlainArgsBuilder internal constructor() {
    private var filters: List<GetVpcAttachmentFilter>? = null

    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("ukedgsvxojxitgrg")
    public suspend fun filters(`value`: List<GetVpcAttachmentFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("pslbgqnfehhetnjm")
    public suspend fun filters(argument: List<suspend GetVpcAttachmentFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVpcAttachmentFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("ojpsqrrlexaqovyd")
    public suspend fun filters(vararg argument: suspend GetVpcAttachmentFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetVpcAttachmentFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("kradhkbniywsguej")
    public suspend fun filters(argument: suspend GetVpcAttachmentFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVpcAttachmentFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("rhdchuwqyoljsrxp")
    public suspend fun filters(vararg values: GetVpcAttachmentFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Identifier of the EC2 Transit Gateway VPC Attachment.
     */
    @JvmName("gsqfhrmnbyaaypqp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway VPC Attachment
     */
    @JvmName("athrwmcffohnourg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway VPC Attachment
     */
    @JvmName("lyqrblxuhecybowc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetVpcAttachmentPlainArgs = GetVpcAttachmentPlainArgs(
        filters = filters,
        id = id,
        tags = tags,
    )
}
