@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetVpcAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcAttachments.
 * @property filters One or more configuration blocks containing name-values filters. Detailed below.
 */
public data class GetVpcAttachmentsPlainArgs(
    public val filters: List<GetVpcAttachmentsFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetVpcAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetVpcAttachmentsPlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetVpcAttachmentsPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetVpcAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetVpcAttachmentsPlainArgsBuilder internal constructor() {
    private var filters: List<GetVpcAttachmentsFilter>? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("pnwoarrspvqitamb")
    public suspend fun filters(`value`: List<GetVpcAttachmentsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("iaxryksmbkiajalk")
    public suspend fun filters(argument: List<suspend GetVpcAttachmentsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVpcAttachmentsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("fwmdfwaywignpipe")
    public suspend fun filters(vararg argument: suspend GetVpcAttachmentsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetVpcAttachmentsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("qaefwesvorbylieb")
    public suspend fun filters(argument: suspend GetVpcAttachmentsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVpcAttachmentsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("ahbnylhuxqepwbrl")
    public suspend fun filters(vararg values: GetVpcAttachmentsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetVpcAttachmentsPlainArgs = GetVpcAttachmentsPlainArgs(
        filters = filters,
    )
}
