@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetVpnAttachmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpnAttachment.
 * @property filters Configuration block(s) for filtering. Detailed below.
 * @property tags Map of tags, each pair of which must exactly match a pair on the desired Transit Gateway VPN Attachment.
 * @property transitGatewayId Identifier of the EC2 Transit Gateway.
 * @property vpnConnectionId Identifier of the EC2 VPN Connection.
 */
public data class GetVpnAttachmentPlainArgs(
    public val filters: List<GetVpnAttachmentFilter>? = null,
    public val tags: Map<String, String>? = null,
    public val transitGatewayId: String? = null,
    public val vpnConnectionId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetVpnAttachmentPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetVpnAttachmentPlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetVpnAttachmentPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayId(transitGatewayId?.let({ args0 -> args0 }))
            .vpnConnectionId(vpnConnectionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpnAttachmentPlainArgs].
 */
@PulumiTagMarker
public class GetVpnAttachmentPlainArgsBuilder internal constructor() {
    private var filters: List<GetVpnAttachmentFilter>? = null

    private var tags: Map<String, String>? = null

    private var transitGatewayId: String? = null

    private var vpnConnectionId: String? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("wrgcmeqdnxmppftc")
    public suspend fun filters(`value`: List<GetVpnAttachmentFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("hvnlvegvadvhxopx")
    public suspend fun filters(argument: List<suspend GetVpnAttachmentFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVpnAttachmentFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("hllowberrdwnsbdp")
    public suspend fun filters(vararg argument: suspend GetVpnAttachmentFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetVpnAttachmentFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("xjqqkrnolfebkirp")
    public suspend fun filters(argument: suspend GetVpnAttachmentFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVpnAttachmentFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("dfjhycjrprlmoxgg")
    public suspend fun filters(vararg values: GetVpnAttachmentFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match a pair on the desired Transit Gateway VPN Attachment.
     */
    @JvmName("kghvqhyuognsuawe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match a pair on the desired Transit Gateway VPN Attachment.
     */
    @JvmName("omipdxajxlmkjqfa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Identifier of the EC2 Transit Gateway.
     */
    @JvmName("mxscoqqkvufvjcgy")
    public suspend fun transitGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitGatewayId = mapped
    }

    /**
     * @param value Identifier of the EC2 VPN Connection.
     */
    @JvmName("hbyknevnvarxlwwq")
    public suspend fun vpnConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpnConnectionId = mapped
    }

    internal fun build(): GetVpnAttachmentPlainArgs = GetVpnAttachmentPlainArgs(
        filters = filters,
        tags = tags,
        transitGatewayId = transitGatewayId,
        vpnConnectionId = vpnConnectionId,
    )
}
