@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.InstanceConnectEndpointTimeoutsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property create A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
 * @property delete A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
 */
public data class InstanceConnectEndpointTimeoutsArgs(
    public val create: Output<String>? = null,
    public val delete: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.InstanceConnectEndpointTimeoutsArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.InstanceConnectEndpointTimeoutsArgs = com.pulumi.aws.ec2transitgateway.inputs.InstanceConnectEndpointTimeoutsArgs.builder()
        .create(create?.applyValue({ args0 -> args0 }))
        .delete(delete?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceConnectEndpointTimeoutsArgs].
 */
@PulumiTagMarker
public class InstanceConnectEndpointTimeoutsArgsBuilder internal constructor() {
    private var create: Output<String>? = null

    private var delete: Output<String>? = null

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
     */
    @JvmName("ruonjbqrdkfjawkc")
    public suspend fun create(`value`: Output<String>) {
        this.create = value
    }

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
     */
    @JvmName("cuferbcthavxqkit")
    public suspend fun delete(`value`: Output<String>) {
        this.delete = value
    }

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
     */
    @JvmName("oinhiynbqjkltyqd")
    public suspend fun create(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.create = mapped
    }

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
     */
    @JvmName("ryxmeqeqbgksgmuu")
    public suspend fun delete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delete = mapped
    }

    internal fun build(): InstanceConnectEndpointTimeoutsArgs = InstanceConnectEndpointTimeoutsArgs(
        create = create,
        delete = delete,
    )
}
